/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.text;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQueryResultHandlerException;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultWriter;
import org.openrdf.query.resultio.QueryResultWriterBase;

public class BooleanTextWriter
extends QueryResultWriterBase
implements BooleanQueryResultWriter {
    private Writer writer;

    public BooleanTextWriter(OutputStream out) {
        this.writer = new OutputStreamWriter(out, Charset.forName("US-ASCII"));
    }

    @Override
    public final BooleanQueryResultFormat getBooleanQueryResultFormat() {
        return BooleanQueryResultFormat.TEXT;
    }

    @Override
    public final BooleanQueryResultFormat getQueryResultFormat() {
        return this.getBooleanQueryResultFormat();
    }

    @Override
    public void write(boolean value) throws IOException {
        try {
            this.handleBoolean(value);
        }
        catch (QueryResultHandlerException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    @Override
    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        try {
            this.writer.write(Boolean.toString(value));
            this.writer.flush();
        }
        catch (IOException e) {
            throw new BooleanQueryResultHandlerException(e);
        }
    }

    @Override
    public void startDocument() throws QueryResultHandlerException {
    }

    @Override
    public void handleStylesheet(String stylesheetUrl) throws QueryResultHandlerException {
    }

    @Override
    public void startHeader() throws QueryResultHandlerException {
    }

    @Override
    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
    }

    @Override
    public void endHeader() throws QueryResultHandlerException {
    }

    @Override
    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle tuple results");
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle tuple results");
    }

    @Override
    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle tuple results");
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }
}

