/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.nquads;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.ntriples.NTriplesUtil;
import org.openrdf.rio.ntriples.NTriplesWriter;

public class NQuadsWriter
extends NTriplesWriter {
    public NQuadsWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public NQuadsWriter(Writer writer) {
        super(writer);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.NQUADS;
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        try {
            NTriplesUtil.append(st.getSubject(), (Appendable)this.writer);
            this.writer.write(" ");
            NTriplesUtil.append(st.getPredicate(), (Appendable)this.writer);
            this.writer.write(" ");
            NTriplesUtil.append(st.getObject(), (Appendable)this.writer);
            if (null != st.getContext()) {
                this.writer.write(" ");
                NTriplesUtil.append(st.getContext(), (Appendable)this.writer);
            }
            this.writer.write(" .\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }
}

