/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.SQLException;
import java.util.List;
import org.openrdf.sail.rdbms.exceptions.RdbmsRuntimeException;
import org.openrdf.sail.rdbms.schema.RdbmsTable;

public class NamespacesTable {
    private RdbmsTable table;
    private String INSERT;
    private String UPDATE;
    private String UPDATE_ALL_NULL;

    public NamespacesTable(RdbmsTable table) {
        this.table = table;
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(table.getName());
        sb.append(" (prefix, namespace) VALUES (?, ?)");
        this.INSERT = sb.toString();
        sb.delete(0, sb.length());
        sb.append("UPDATE ").append(table.getName()).append("\n");
        sb.append("SET prefix = ?\n");
        sb.append("WHERE namespace = ?");
        this.UPDATE = sb.toString();
        sb.delete(0, sb.length());
        sb.append("UPDATE ").append(table.getName()).append("\n");
        sb.append("SET prefix = NULL\n");
        sb.append("WHERE prefix IS NOT NULL");
        this.UPDATE_ALL_NULL = sb.toString();
    }

    public void initialize() throws SQLException {
        if (!this.table.isCreated()) {
            this.createTable();
        }
    }

    public void close() throws SQLException {
        this.table.close();
    }

    protected void createTable() throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("  prefix VARCHAR(127),\n");
        sb.append("  namespace TEXT NOT NULL\n");
        this.createTable(sb);
    }

    protected void createTable(CharSequence sb) throws SQLException {
        this.table.createTable(sb);
    }

    public void insert(String prefix, String namespace) throws SQLException {
        int result = this.table.executeUpdate(this.INSERT, prefix, namespace);
        if (result != 1 && result != -2) {
            throw new RdbmsRuntimeException("Namespace could not be created");
        }
        this.table.modified(1, 0);
        this.table.optimize();
    }

    public void updatePrefix(String prefix, String namespace) throws SQLException {
        int result = this.table.executeUpdate(this.UPDATE, prefix, namespace);
        if (result != 1 && result != -2) {
            throw new RdbmsRuntimeException("Namespace prefix could not be changed, result: " + result);
        }
    }

    public void clearPrefixes() throws SQLException {
        this.table.execute(this.UPDATE_ALL_NULL);
    }

    public List<Object[]> selectAll() throws SQLException {
        return this.table.select("prefix", "namespace");
    }

    public String toString() {
        return this.table.getName();
    }
}

