/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.accessor;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDF;
import slib.graph.algo.accessor.GraphAccessor;
import slib.graph.algo.accessor.InstanceAccessor;
import slib.graph.model.graph.G;
import slib.graph.model.graph.utils.Direction;

public class InstanceAccessorTax
implements InstanceAccessor {
    Set<URI> instances;
    final G graph;

    public InstanceAccessorTax(G graph) {
        this.graph = graph;
    }

    @Override
    public Iterator<URI> getInstancesIt() {
        return this.getInstances().iterator();
    }

    @Override
    public Set<URI> getInstances() {
        if (this.instances == null) {
            this.instances = GraphAccessor.getInstances(this.graph);
        }
        return Collections.unmodifiableSet(this.instances);
    }

    @Override
    public int getInstanceNb() {
        return this.getInstances().size();
    }

    @Override
    public Iterator<URI> getClassesOfInstanceIt(URI instance) {
        return this.getClassesOfInstance(instance).iterator();
    }

    @Override
    public Set<URI> getClassesOfInstance(URI instance) {
        return this.graph.getV(instance, RDF.TYPE, Direction.OUT);
    }
}

