/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader;

import java.util.Collection;
import org.openrdf.model.URI;
import org.openrdf.rio.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.utils.GraphActionExecutor;
import slib.graph.io.conf.GDataConf;
import slib.graph.io.conf.GraphConf;
import slib.graph.io.loader.GraphLoader;
import slib.graph.io.loader.annot.GraphLoader_TSVannot;
import slib.graph.io.loader.bio.gaf2.GraphLoader_GAF_2;
import slib.graph.io.loader.bio.mesh.GraphLoader_MESH_XML;
import slib.graph.io.loader.bio.obo.GraphLoader_OBO_1_2;
import slib.graph.io.loader.bio.snomedct.GraphLoaderSnomedCT_RF2;
import slib.graph.io.loader.csv.GraphLoader_CSV;
import slib.graph.io.loader.rdf.RDFLoader;
import slib.graph.io.loader.slibformat.GraphLoader_SLIB;
import slib.graph.io.loader.wordnet.GraphLoader_Wordnet;
import slib.graph.io.util.GFormat;
import slib.graph.model.graph.G;
import slib.graph.model.impl.graph.memory.GraphMemory;
import slib.graph.model.impl.repo.GraphRepositoryMemory;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class GraphLoaderGeneric {
    public static Logger logger = LoggerFactory.getLogger(GraphLoaderGeneric.class);
    public static GFormat[] supportedFormat = new GFormat[]{GFormat.OBO, GFormat.GAF2, GFormat.NTRIPLES, GFormat.RDF_XML, GFormat.RDF_XML, GFormat.SNOMED_CT_RF2, GFormat.MESH_XML, GFormat.CSV, GFormat.TSV_ANNOT, GFormat.WORDNET_DATA};

    public static G populate(GDataConf dataConf, G g) throws SLIB_Exception {
        logger.debug("Populate " + g.getURI() + " based on " + dataConf.getLoc());
        GraphLoader gLoader = GraphLoaderGeneric.getLoader(dataConf);
        gLoader.populate(dataConf, g);
        return g;
    }

    public static G createGraph(URI uri) {
        logger.debug("Create graph " + uri);
        GraphMemory g = new GraphMemory(uri);
        GraphRepositoryMemory.getSingleton().registerGraph(g);
        return g;
    }

    public static G load(GraphConf graphConf) throws SLIB_Exception {
        logger.info("Loading Graph " + graphConf.getUri());
        G g = GraphLoaderGeneric.createGraph(graphConf.getUri());
        return GraphLoaderGeneric.load(graphConf, g);
    }

    public static G load(GraphConf graphConf, G g) throws SLIB_Exception {
        logger.info("-------------------------------------");
        logger.info(" Loading DATA");
        logger.info("-------------------------------------");
        for (GDataConf dataConf : graphConf.getData()) {
            GraphLoaderGeneric.populate(dataConf, g);
        }
        URIFactoryMemory factory = URIFactoryMemory.getSingleton();
        GraphActionExecutor.applyActions(factory, graphConf.getActions(), g);
        return g;
    }

    public static void load(Collection<GraphConf> graphConfs) throws SLIB_Exception {
        for (GraphConf conf : graphConfs) {
            GraphLoaderGeneric.load(conf);
        }
    }

    private static GraphLoader getLoader(GDataConf data) throws SLIB_Ex_Critic {
        if (data.getFormat() == GFormat.OBO) {
            return new GraphLoader_OBO_1_2();
        }
        if (data.getFormat() == GFormat.GAF2) {
            return new GraphLoader_GAF_2();
        }
        if (data.getFormat() == GFormat.RDF_XML) {
            return new RDFLoader(RDFFormat.RDFXML);
        }
        if (data.getFormat() == GFormat.NTRIPLES) {
            return new RDFLoader(RDFFormat.NTRIPLES);
        }
        if (data.getFormat() == GFormat.TURTLE) {
            return new RDFLoader(RDFFormat.TURTLE);
        }
        if (data.getFormat() == GFormat.CSV) {
            return new GraphLoader_CSV();
        }
        if (data.getFormat() == GFormat.SNOMED_CT_RF2) {
            return new GraphLoaderSnomedCT_RF2();
        }
        if (data.getFormat() == GFormat.SLIB) {
            return new GraphLoader_SLIB();
        }
        if (data.getFormat() == GFormat.MESH_XML) {
            return new GraphLoader_MESH_XML();
        }
        if (data.getFormat() == GFormat.TSV_ANNOT) {
            return new GraphLoader_TSVannot();
        }
        if (data.getFormat() == GFormat.WORDNET_DATA) {
            return new GraphLoader_Wordnet();
        }
        throw new SLIB_Ex_Critic("Unknown Graph format " + (Object)((Object)data.getFormat()));
    }

    public static boolean supportFormat(String format) {
        for (GFormat f : supportedFormat) {
            if (!f.name().equalsIgnoreCase(format)) continue;
            return true;
        }
        return false;
    }

    public static GFormat[] getSupportedFormat() {
        return supportedFormat;
    }
}

