/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader.rdf;

import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.model.graph.G;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.graph.model.repo.URIFactory;

public class SlibRdfHandler
implements RDFHandler {
    G g;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    int count = 0;
    int countSkipped = 0;
    URIFactory factory;

    public SlibRdfHandler(G g) {
        this.g = g;
        this.factory = URIFactoryMemory.getSingleton();
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.logger.info("Start Process");
        this.count = 0;
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.logger.info("Ending Process " + this.count + " statements loaded ");
        this.logger.info("vertices: " + this.g.getV().size());
        this.logger.info("edges   : " + this.g.getE().size());
        this.logger.info("Skipped (statement involving non URI ressources) : " + this.countSkipped);
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        Resource s = st.getSubject();
        Value o = st.getObject();
        if (s instanceof URI && o instanceof URI) {
            this.g.addE((URI)s, st.getPredicate(), (URI)o);
            ++this.count;
        } else {
            ++this.countSkipped;
        }
        if (this.count % 100000 == 0) {
            this.logger.info(this.count + " statements already loaded");
            this.logger.info("Number of vertices: " + this.g.getV().size());
            this.logger.info("Number of edges   : " + this.g.getE().size());
        }
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
    }
}

