/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.utils.impl.SetUtils;

public class WalkConstraintGeneric
implements WalkConstraint {
    Set<URI> acceptedWalksIN = new HashSet<URI>();
    Set<URI> acceptedWalksOUT = new HashSet<URI>();

    public WalkConstraintGeneric() {
    }

    public WalkConstraintGeneric(Map<URI, Direction> walkRules) {
        for (Map.Entry<URI, Direction> e : walkRules.entrySet()) {
            Direction dir = e.getValue();
            if (dir == Direction.IN || dir == Direction.BOTH) {
                this.acceptedWalksIN.add(e.getKey());
            }
            if (dir != Direction.OUT && dir != Direction.BOTH) continue;
            this.acceptedWalksOUT.add(e.getKey());
        }
    }

    public WalkConstraintGeneric(URI acceptedPredicate, Direction dir) {
        if (dir == Direction.IN || dir == Direction.BOTH) {
            this.acceptedWalksIN.add(acceptedPredicate);
        }
        if (dir == Direction.OUT || dir == Direction.BOTH) {
            this.acceptedWalksOUT.add(acceptedPredicate);
        }
    }

    @Override
    public boolean respectConstaints(E e, Direction dir) {
        boolean valid = false;
        if (dir == Direction.IN || dir == Direction.BOTH) {
            valid = this.acceptedWalksIN.contains(e.getURI());
        }
        if (dir == Direction.OUT || !valid && dir == Direction.BOTH) {
            valid = this.acceptedWalksOUT.contains(e.getURI());
        }
        return valid;
    }

    @Override
    public Set<URI> getAcceptedPredicates() {
        HashSet<URI> union = new HashSet<URI>();
        union.addAll(this.acceptedWalksIN);
        union.addAll(this.acceptedWalksOUT);
        return union;
    }

    @Override
    public Set<URI> getAcceptedWalks_DIR_IN() {
        return Collections.unmodifiableSet(this.acceptedWalksIN);
    }

    @Override
    public Set<URI> getAcceptedWalks_DIR_OUT() {
        return Collections.unmodifiableSet(this.acceptedWalksOUT);
    }

    @Override
    public Set<URI> getAcceptedWalks_DIR_BOTH() {
        Set<URI> acceptedWalks = SetUtils.intersection(this.acceptedWalksIN, this.acceptedWalksOUT);
        return acceptedWalks;
    }

    @Override
    public Direction getAssociatedDirection(URI uri) {
        Direction dir = null;
        if (this.acceptedWalksIN.contains(uri)) {
            dir = Direction.IN;
        }
        if (this.acceptedWalksOUT.contains(uri)) {
            dir = dir != null ? Direction.BOTH : Direction.OUT;
        }
        return dir;
    }

    @Override
    public void addAcceptedTraversal(URI pred, Direction dir) {
        if (dir == Direction.OUT || dir == Direction.BOTH) {
            this.acceptedWalksOUT.add(pred);
        }
        if (dir == Direction.IN || dir == Direction.BOTH) {
            this.acceptedWalksIN.add(pred);
        }
    }

    @Override
    public void addAcceptedTraversal(Set<URI> pred, Direction dir) {
        if (dir == Direction.OUT || dir == Direction.BOTH) {
            this.acceptedWalksOUT.addAll(pred);
        }
        if (dir == Direction.IN || dir == Direction.BOTH) {
            this.acceptedWalksIN.addAll(pred);
        }
    }

    @Override
    public void addWalkconstraints(WalkConstraint wc) {
        this.acceptedWalksIN.addAll(wc.getAcceptedWalks_DIR_IN());
        this.acceptedWalksOUT.addAll(wc.getAcceptedWalks_DIR_OUT());
    }

    @Override
    public boolean acceptOutWalks() {
        return !this.acceptedWalksOUT.isEmpty();
    }

    @Override
    public boolean acceptInWalks() {
        return !this.acceptedWalksIN.isEmpty();
    }

    public String toString() {
        String out = "Walconstraint\n\tAcceptedWalkIN: \n";
        for (URI e : this.acceptedWalksIN) {
            out = out + "\t\t" + e + "\n";
        }
        out = out + "\tAcceptedWalkOUT:\n";
        for (URI e : this.acceptedWalksOUT) {
            out = out + "\t\t" + e + "\n";
        }
        return out;
    }
}

