/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.hybrid.experimental;

import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.graph.model.graph.weight.GWS;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.Sim_DAG_edge_abstract;
import slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.utils.SimDagEdgeUtils;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.SetUtils;

public class Sim_pairwise_DAG_edge_Li_2003
extends Sim_DAG_edge_abstract {
    double alpha = 0.2;
    double beta = 0.6;

    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        GWS weightingScheme = c.getWeightingScheme(conf.getParamAsString("WEIGHTING_SCHEME"));
        double sp_AtoB = c.getShortestPath(a, b, weightingScheme);
        Set<URI> ancestors_A = c.getAncestorsInc(a);
        Set<URI> ancestors_B = c.getAncestorsInc(b);
        Map<URI, Integer> maxDepths = c.getMaxDepths();
        return this.sim(sp_AtoB, ancestors_A, ancestors_B, maxDepths);
    }

    public double sim(double sp_AtoB, Set<URI> ancestors_A, Set<URI> ancestors_B, Map<URI, Integer> maxDepths) throws SLIB_Exception {
        double sim = 0.0;
        Set<URI> interSecAncestors = SetUtils.intersection(ancestors_A, ancestors_B);
        if (!interSecAncestors.isEmpty()) {
            URI msa = SimDagEdgeUtils.searchMSA(interSecAncestors, maxDepths);
            int h = maxDepths.get(msa);
            double f1 = Math.exp(-this.alpha * sp_AtoB);
            double f2 = (Math.exp(this.beta * (double)h) - Math.exp(-this.beta * (double)h)) / (Math.exp(this.beta * (double)h) + Math.exp(-this.beta * (double)h));
            sim = f1 * f2;
        }
        return sim;
    }
}

