/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.metrics.ic.topo;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.metrics.ic.topo.ICtopo;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Topo;
import slib.sml.sm.core.metrics.utils.LogBasedMetric;
import slib.sml.sm.core.utils.MathSML;
import slib.utils.ex.SLIB_Ex_Critic;

public class ICi_seco_2004
extends LogBasedMetric
implements ICtopo {
    public Map<URI, Double> compute(Map<URI, Set<URI>> allDescendantsInc) throws SLIB_Ex_Critic {
        HashMap<URI, Double> results = new HashMap<URI, Double>();
        double setSize = allDescendantsInc.size();
        for (URI v : allDescendantsInc.keySet()) {
            double cur_ic;
            double nbDesc = allDescendantsInc.get(v).size();
            try {
                cur_ic = this.computeIC(nbDesc, setSize);
            }
            catch (SLIB_Ex_Critic e) {
                throw new SLIB_Ex_Critic("Error computing IC of concept " + v + "\n" + e.getMessage());
            }
            results.put(v, cur_ic);
        }
        return results;
    }

    @Override
    public Map<URI, Double> compute(IC_Conf_Topo conf, SM_Engine engine) throws SLIB_Ex_Critic {
        this.setLogBase(conf);
        return this.compute(engine.getAllDescendantsInc());
    }

    public double computeIC(double nbInclusiveDescendants, double nbConceptsOnto) throws SLIB_Ex_Critic {
        double x = MathSML.log(nbInclusiveDescendants, this.getLogBase()) / MathSML.log(nbConceptsOnto, this.getLogBase());
        double ic = 1.0 - x;
        if (Double.isNaN(ic) || Double.isInfinite(ic)) {
            throw new SLIB_Ex_Critic("Incoherency found in IC " + this.getClass() + "\nNB inclusive Descendants       " + nbInclusiveDescendants + "\nNB concepts onto       " + nbConceptsOnto + "\nLog base       " + this.getLogBase() + "\nLog nbDesc     " + MathSML.log(nbInclusiveDescendants, this.getLogBase()) + "\nLog Set size   " + MathSML.log(nbConceptsOnto, this.getLogBase()) + "\nIC is set to " + ic + "\nNumber of Descendants: " + nbInclusiveDescendants + "\nSetSize: " + nbConceptsOnto + "\n");
        }
        return ic;
    }
}

