/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.metrics.ic.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.SetUtils;

public class IcUtils {
    public static URI searchMICA(URI a, URI b, Set<URI> setA, Set<URI> setB, Map<URI, Double> icScores) throws SLIB_Exception {
        URI mica = null;
        if (a.equals(b)) {
            mica = a;
        } else {
            Set<URI> intersec = SetUtils.intersection(setA, setB);
            if (intersec.isEmpty()) {
                throw new SLIB_Ex_Critic("Error detecting the common ancestors with the maximal IC\nSearching a max from an empty collection, be sure the compared concepts are locate under the specified root... setA" + setA + "\tsetB" + setB);
            }
            if (icScores == null) {
                throw new SLIB_Ex_Critic("Empty IC result stack... Treatment cannot be performed");
            }
            Iterator<URI> it = intersec.iterator();
            double max = -1.7976931348623157E308;
            while (it.hasNext()) {
                URI v = it.next();
                if (mica != null && !(max < icScores.get(v))) continue;
                max = icScores.get(v);
                mica = v;
            }
        }
        return mica;
    }

    public static Double searchMax_IC_MICA(URI a, URI b, Set<URI> setA, Set<URI> setB, Map<URI, Double> icScores) throws SLIB_Exception {
        URI mica = IcUtils.searchMICA(a, b, setA, setB, icScores);
        return icScores.get(mica);
    }

    public static Double searchMin_pOc_MICA(Set<URI> setA, Set<URI> setB, Map<URI, Double> icScores) throws SLIB_Exception {
        Set<URI> intersec = SetUtils.intersection(setA, setB);
        Double min = null;
        if (!intersec.isEmpty() && icScores != null) {
            Iterator<URI> it = intersec.iterator();
            min = icScores.get(it.next());
            while (it.hasNext()) {
                URI v = it.next();
                if (!(min > icScores.get(v))) continue;
                min = icScores.get(v);
            }
        }
        return min;
    }
}

