/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.module;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import slib.tools.module.GlobalConfPattern;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.i.Conf;

public class GenericConfBuilder {
    static final Pattern patternRgx = Pattern.compile("\\{([^\\{^\\}]*)\\}");

    public static String applyGlobalPatterns(String v) throws SLIB_Ex_Critic {
        if (v == null) {
            return null;
        }
        Matcher m = patternRgx.matcher(v);
        HashMap<String, String> variables = GlobalConfPattern.getInstance().getVariables();
        String newValue = v;
        while (m.find()) {
            String vName = m.group(1);
            String value = variables.get(vName);
            if (value == null) {
                String loadedPatters = "";
                if (variables.size() == 0) {
                    loadedPatters = " : None\n";
                }
                for (String k : variables.keySet()) {
                    loadedPatters = loadedPatters + "key='" + k + "'\tvalue='" + variables.get(k) + "'\n";
                }
                throw new SLIB_Ex_Critic("Undefined pattern '" + vName + "' used in " + v + " please define a pattern (see " + "var" + " tag).\nLoaded patters " + loadedPatters + "If you are not aware of pattern please remove '{' and '}' characters");
            }
            newValue = newValue.replaceAll("\\{" + vName + "\\}", value);
        }
        return newValue;
    }

    public static Conf build(Element e) throws SLIB_Ex_Critic {
        Conf m = new Conf();
        for (int j = 0; j < e.getAttributes().getLength(); ++j) {
            String p = e.getAttributes().item(j).getNodeName();
            String v = e.getAttributes().item(j).getTextContent();
            v = GenericConfBuilder.applyGlobalPatterns(v);
            m.addParam(p, v);
        }
        return m;
    }

    public static LinkedHashSet<Conf> build(NodeList list) throws SLIB_Ex_Critic {
        LinkedHashSet<Conf> gConfSet = new LinkedHashSet<Conf>();
        for (int i = 0; i < list.getLength(); ++i) {
            Conf m = GenericConfBuilder.build((Element)list.item(i));
            gConfSet.add(m);
        }
        return gConfSet;
    }
}

