/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.smltoolkit.sm.cli.conf.xml.loader;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Corpus;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Topo;
import slib.sml.sm.core.metrics.ic.utils.ICconf;
import slib.sml.sm.core.utils.OperatorConf;
import slib.sml.sm.core.utils.SMConstants;
import slib.sml.sm.core.utils.SMconf;
import slib.tools.module.GenericConfBuilder;
import slib.tools.module.XML_ModuleConfLoader;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.i.Conf;
import slib.utils.impl.Util;

public class Sm_XMLConfLoader
extends XML_ModuleConfLoader {
    Logger logger = LoggerFactory.getLogger(Sm_XMLConfLoader.class);
    public LinkedHashSet<SMconf> gConfPairwise = new LinkedHashSet();
    public LinkedHashSet<SMconf> gConfGroupwise = new LinkedHashSet();
    public LinkedHashSet<ICconf> gConfICs;
    public LinkedHashSet<Conf> gConfQueries = new LinkedHashSet();
    public LinkedHashSet<OperatorConf> gConfOperators;
    Integer nbThreads;
    Integer benchSize;
    Boolean cachePairwiseResults;
    boolean quiet = false;
    public String graphURI;

    public Sm_XMLConfLoader(String confFile) throws SLIB_Exception {
        super(confFile);
        this.gConfICs = new LinkedHashSet();
        this.gConfOperators = new LinkedHashSet();
        this.logger.info("Loading sm Configuration : " + confFile);
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(new File(confFile));
            NodeList smNode = document.getElementsByTagName("sml");
            if (smNode.getLength() == 1 && smNode.item(0) instanceof Element) {
                String includeFile;
                Conf gconf = (Conf)GenericConfBuilder.build(smNode).iterator().next();
                String module = (String)gconf.getParam("module");
                if (module == null || !module.equals("sm")) {
                    Util.error("Please specify a attribut module='sm' to tag sml");
                }
                this.graphURI = (String)gconf.getParam("graph");
                if (this.graphURI == null) {
                    Util.error("Please specify a attribut graph='graph_uri' to tag sml specifying which graph must be considered ");
                }
                if ((includeFile = (String)gconf.getParam("include")) != null) {
                    this.logger.info("including " + includeFile);
                    DocumentBuilder p = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document dinc = p.parse(new File(includeFile));
                    this.loadData(dinc);
                }
            } else if (smNode.getLength() == 0) {
                Util.error("A sml tag must be specified");
            } else {
                Util.error("A unique sml tag must be specified");
            }
            this.loadData(document);
            this.checkData();
            this.logger.info("Configuration loaded... ");
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SLIB_Exception(e.getMessage());
        }
    }

    private void checkData() throws SLIB_Ex_Critic {
        this.checkIcs();
        this.checkPairwiseMeasures();
        this.checkGroupwiseMeasures();
        this.checkQueries();
    }

    private void loadData(Document document) throws SLIB_Ex_Critic {
        NodeList opt = document.getElementsByTagName("opt_module");
        if (opt.getLength() == 1 && opt.item(0) instanceof Element) {
            this.extractOptConf(GenericConfBuilder.build((Element)opt.item(0)));
        } else if (opt.getLength() > 1) {
            Util.error("Only one opt_module tag allowed");
        }
        NodeList ics = document.getElementsByTagName("ics");
        for (int i = 0; i < ics.getLength(); ++i) {
            if (!(ics.item(i) instanceof Element)) continue;
            this.loadICs((Element)ics.item(i));
        }
        NodeList measure = document.getElementsByTagName("measures");
        for (int i = 0; i < measure.getLength(); ++i) {
            if (!(measure.item(i) instanceof Element)) continue;
            this.processMeasureSpec((Element)measure.item(i));
        }
        NodeList queries = document.getElementsByTagName("queries");
        for (int i = 0; i < queries.getLength(); ++i) {
            if (!(queries.item(i) instanceof Element)) continue;
            this.loadQueries((Element)queries.item(i));
        }
    }

    private void checkQueries() throws SLIB_Ex_Critic {
        for (Conf conf : this.gConfQueries) {
            String type = (String)conf.getParam("type");
            String output = (String)conf.getParam("output");
            if (output == null) {
                Util.error("Please specify an output file for each query");
            }
            if (type.equals("cTOc") || type.equals("oTOo") || type.equals("cTOc_full")) continue;
            Util.error("Please precise a valid type to all queries, error due to type=" + type);
        }
    }

    private void checkIcs() throws SLIB_Ex_Critic {
        for (ICconf m : this.gConfICs) {
            String flag = m.getFlag();
            String id = m.getId();
            String label = m.getLabel();
            if (SMConstants.IC_FLAGS.contains(flag)) {
                for (ICconf mm : this.gConfICs) {
                    if (mm == m || !label.equals(mm.getLabel()) && !id.equals(mm.getId())) continue;
                    if (id.equals(mm.getId())) {
                        Util.error("Duplicate IC id:" + m.getId());
                        continue;
                    }
                    Util.error("Duplicate IC label:" + label);
                }
                continue;
            }
            if (flag == null) {
                Util.error("A flag must be specified to each IC tag specified");
                continue;
            }
            Util.error("Unknown IC flag:" + flag);
        }
        this.logger.info(this.gConfICs.size() + " IC configurations loaded ");
    }

    private void loadQueries(Element item) throws SLIB_Ex_Critic {
        Conf querySet = GenericConfBuilder.build(item);
        this.gConfQueries.add(querySet);
    }

    private void loadICs(Element item) throws SLIB_Ex_Critic {
        NodeList list = item.getElementsByTagName("ic");
        LinkedHashSet<Conf> gConfICsGenerics = GenericConfBuilder.build(list);
        this.gConfICs.addAll(this.buildICconf(gConfICsGenerics));
    }

    private void checkPairwiseMeasures() throws SLIB_Ex_Critic {
        for (SMconf m : this.gConfPairwise) {
            String id = m.getId();
            String flag = m.getFlag();
            String label = m.getLabel();
            if (SMConstants.PAIRWISE_MEASURE_FLAGS.contains(flag)) {
                if (id == null) {
                    Util.error("Please specify an id tag for all pairwise measure flag:" + flag);
                }
                for (SMconf mm : this.gConfPairwise) {
                    if (mm == m || !id.equals(mm.getId())) continue;
                    Util.error("Duplicate id value for pairwise measure:" + id);
                }
                if (label == null) {
                    m.setLabel(id);
                }
                for (SMconf mm : this.gConfPairwise) {
                    if (mm == m || !m.getLabel().equals(mm.getLabel())) continue;
                    Util.error("Duplicate label:" + m.getLabel());
                }
                if (!SMConstants.MEASURE_FLAGS_IC_DEPENDENCY.contains(flag)) continue;
                ICconf ic = m.getICconf();
                if (ic == null || ic.getId() == null) {
                    Util.error("Please specify an IC to node based measure: " + m.getId());
                }
                boolean valid = false;
                for (ICconf gc : this.gConfICs) {
                    if (!gc.getId().equals(ic.getId())) continue;
                    valid = true;
                    break;
                }
                if (valid) continue;
                Util.error("Cannot resolve IC '" + ic + "' specified for pairwise measure '" + label + "'");
                continue;
            }
            if (flag == null) {
                Util.error("A pairwise measure have no specified flag ");
                continue;
            }
            Util.error("Unknown pairwise measure flag:" + flag);
        }
        this.logger.info(this.gConfPairwise.size() + " pairwise measure configurations loaded ");
    }

    private void checkGroupwiseMeasures() throws SLIB_Ex_Critic {
        for (SMconf m : this.gConfGroupwise) {
            String id = m.getId();
            String flag = m.getFlag();
            String label = m.getLabel();
            String pairwise_measure = m.getParamAsString("pairwise_measure");
            if (SMConstants.GROUPWISE_MEASURE_FLAGS.contains(flag)) {
                if (id == null) {
                    Util.error("Please specify an id tag for all groupwise measures");
                }
                if (SMConstants.SIM_GROUPWISE_ADD_ON.containsKey(flag)) {
                    if (pairwise_measure == null) {
                        Util.error("Please specify a pairwise measure associated to groupwise measures id=" + id);
                    }
                    boolean valid = false;
                    for (SMconf mm : this.gConfPairwise) {
                        if (!mm.getId().equals(pairwise_measure)) continue;
                        valid = true;
                        break;
                    }
                    if (!valid) {
                        throw new SLIB_Ex_Critic("Cannot refer to unloaded pairwise measure '" + pairwise_measure + "' in groupwise measure definition id=" + id);
                    }
                }
                if (SMConstants.MEASURE_FLAGS_IC_DEPENDENCY.contains(flag)) {
                    ICconf ic = m.getICconf();
                    if (ic == null || ic.getId() == null) {
                        Util.error("Please specify an IC to measure: " + m.getId());
                    }
                    boolean valid = false;
                    for (ICconf gc : this.gConfICs) {
                        if (!gc.getId().equals(ic.getId())) continue;
                        valid = true;
                        break;
                    }
                    if (!valid) {
                        Util.error("Cannot resolve IC '" + ic + "' specified for graoupwise measure '" + label + "'");
                    }
                }
                for (SMconf mm : this.gConfGroupwise) {
                    if (mm == m || !id.equals(mm.getId())) continue;
                    Util.error("Duplicate id value for groupwise measure:" + id);
                }
                if (label == null) {
                    m.setLabel(id);
                }
                for (SMconf mm : this.gConfGroupwise) {
                    if (mm == m || !m.getLabel().equals(mm.getLabel())) continue;
                    Util.error("Duplicate label:" + m.getLabel());
                }
                continue;
            }
            if (flag == null) {
                Util.error("A groupwise measure have no specified flag ");
                continue;
            }
            Util.error("Unknown groupwise measure flag:" + flag);
        }
        this.logger.info(this.gConfGroupwise.size() + " groupwise measure configurations  loaded ");
    }

    private void processMeasureSpec(Element item) throws SLIB_Ex_Critic {
        String type = this.getAttValue(item, "type");
        if (type != null) {
            NodeList list = item.getElementsByTagName("measure");
            LinkedHashSet<Conf> gConf = GenericConfBuilder.build(list);
            if (type.equals("pairwise")) {
                this.gConfPairwise.addAll(this.buildPairwiseConf(gConf));
            } else if (type.equals("groupwise")) {
                this.gConfGroupwise.addAll(this.buildGroupwiseConf(gConf));
            } else {
                Util.error("Unsupported type of measures specified (" + type + ")");
            }
        } else {
            Util.error("Please precise the type of measure associated to 'measures' tag");
        }
    }

    private LinkedHashSet<SMconf> buildPairwiseConf(LinkedHashSet<Conf> gCong) throws SLIB_Ex_Critic {
        LinkedHashSet<SMconf> sspPairwiseConf = new LinkedHashSet<SMconf>();
        for (Conf c : gCong) {
            String id = (String)c.getParam("id");
            String label = (String)c.getParam("label");
            if (label == null) {
                label = id;
            }
            String icID = (String)c.getParam("ic");
            this.logger.debug("Loading measure " + label);
            if (icID != null && icID.equals("[FULL_LIST_IC]")) {
                if (this.gConfICs.size() == 0) {
                    throw new SLIB_Ex_Critic(" Pairwise measure " + label + " requires IC(s) to be defined, none found");
                }
                for (ICconf ic_conf : this.gConfICs) {
                    String avoided = null;
                    if (ic_conf.getParams() != null) {
                        avoided = (String)ic_conf.getParams().get("exclude_auto_measure");
                    }
                    if (Util.stringToBoolean(avoided)) continue;
                    String id_tmp = id + "_" + ic_conf.getId();
                    String label_tmp = label;
                    if (label != null) {
                        label_tmp = label + "_" + ic_conf.getId();
                    }
                    c.addParam("id", id_tmp);
                    c.addParam("label", label_tmp);
                    c.addParam("ic", ic_conf.getId());
                    sspPairwiseConf.add(this.buildPairwiseConf(c));
                }
                continue;
            }
            sspPairwiseConf.add(this.buildPairwiseConf(c));
        }
        return sspPairwiseConf;
    }

    private SMconf buildPairwiseConf(Conf c) throws SLIB_Ex_Critic {
        String[] defaultAttributs = new String[]{"id", "label", "flag", "ic", "ic_prob"};
        String id = (String)c.getParam("id");
        String label = (String)c.getParam("label");
        String flag = (String)c.getParam("flag");
        String icID = (String)c.getParam("ic");
        ICconf icConf = null;
        if (icID != null && (icConf = this.getIC(icID)) == null) {
            throw new SLIB_Ex_Critic("Cannot locate IC " + icID + " define for pairwise measure " + id);
        }
        SMconf pc = new SMconf(id, flag, label, icConf);
        if (SMConstants.MEASURE_REQUIRE_EXTRA_IC.contains(flag)) {
            String ic_prob_id = (String)c.getParam("ic_prob");
            ICconf ic_prob = this.getIC(ic_prob_id);
            if (ic_prob == null) {
                throw new SLIB_Ex_Critic("Cannot locate IC used to compute MICA probability for " + id + ", please define an attribute " + "ic_prob" + " refering to an IC id ");
            }
            pc.addParam("ic_prob", ic_prob);
        }
        pc = this.addExtraAttributs(defaultAttributs, c, pc);
        return pc;
    }

    private <C extends Conf> C addExtraAttributs(String[] defaultAttributs, Conf c, C pc) {
        List<String> def = Arrays.asList(defaultAttributs);
        for (Map.Entry<String, Object> e : c.getParams().entrySet()) {
            if (def.contains(e.getKey())) continue;
            pc.addParam(e.getKey(), e.getValue());
        }
        return pc;
    }

    private ICconf getIC(String icID) {
        for (ICconf ic : this.gConfICs) {
            if (!ic.getId().equals(icID)) continue;
            return ic;
        }
        return null;
    }

    private LinkedHashSet<SMconf> buildGroupwiseConf(LinkedHashSet<Conf> gCong) throws SLIB_Ex_Critic {
        LinkedHashSet<SMconf> sspGoupwiseConf = new LinkedHashSet<SMconf>();
        for (Conf c : gCong) {
            String label_tmp;
            String id_tmp;
            String id = (String)c.getParam("id");
            String label = (String)c.getParam("label");
            String flag = (String)c.getParam("flag");
            String pairwise_measure = (String)c.getParam("pairwise_measure");
            String ic_id = (String)c.getParam("ic");
            if (SMConstants.GROUPWISE_MEASURE_FLAGS.contains(flag) && pairwise_measure != null && pairwise_measure.equals("[FULL_LIST_PM]")) {
                for (SMconf pmConf : this.gConfPairwise) {
                    id_tmp = id + "_" + pmConf.getId();
                    label_tmp = null;
                    if (label != null) {
                        label_tmp = label + "_" + pmConf.getId();
                    }
                    c.addParam("id", id_tmp);
                    c.addParam("label", label_tmp);
                    c.addParam("pairwise_measure", pmConf.getId());
                    if (ic_id != null && ic_id.equals("[FULL_LIST_IC]")) {
                        for (ICconf ic_conf : this.gConfICs) {
                            String id_tmp_2 = id_tmp + "_" + ic_conf.getId();
                            String label_tmp_2 = null;
                            if (label_tmp != null) {
                                label_tmp_2 = label_tmp + "_" + ic_conf.getId();
                            }
                            c.addParam("id", id_tmp_2);
                            c.addParam("label", label_tmp_2);
                            c.addParam("ic", ic_conf.getId());
                            sspGoupwiseConf.add(this.buildGroupwiseConf(c));
                        }
                        continue;
                    }
                    sspGoupwiseConf.add(this.buildGroupwiseConf(c));
                }
                continue;
            }
            if (ic_id != null && ic_id.equals("[FULL_LIST_IC]")) {
                for (ICconf ic_conf : this.gConfICs) {
                    id_tmp = id + "_" + ic_conf.getId();
                    label_tmp = label;
                    if (label != null) {
                        label_tmp = label + "_" + ic_conf.getId();
                    }
                    c.addParam("id", id_tmp);
                    c.addParam("label", label_tmp);
                    c.addParam("ic", ic_conf.getId());
                    sspGoupwiseConf.add(this.buildGroupwiseConf(c));
                }
                continue;
            }
            sspGoupwiseConf.add(this.buildGroupwiseConf(c));
        }
        return sspGoupwiseConf;
    }

    private SMconf buildGroupwiseConf(Conf c) throws SLIB_Ex_Critic {
        String[] defaultAttributs = new String[]{"id", "label", "flag", "ic", "pairwise_measure"};
        String id = (String)c.getParam("id");
        String label = (String)c.getParam("label");
        String flag = (String)c.getParam("flag");
        String ic_id = (String)c.getParam("ic");
        String pairwise_measure = (String)c.getParam("pairwise_measure");
        ICconf icConf = null;
        if (ic_id != null) {
            for (ICconf ic : this.gConfICs) {
                if (!ic.getId().equals(ic_id)) continue;
                icConf = ic;
                break;
            }
            if (icConf == null) {
                throw new SLIB_Ex_Critic("Cannot locate IC " + ic_id + " define for groupwise measure " + id);
            }
        }
        SMconf pc = new SMconf(id, flag, label, icConf);
        pc.addParam("pairwise_measure", pairwise_measure);
        pc = this.addExtraAttributs(defaultAttributs, c, pc);
        return pc;
    }

    private void extractOptConf(Conf gc) throws SLIB_Ex_Critic {
        String benchSize_s = (String)gc.getParam("bench_size");
        String cache_pairwise_s = (String)gc.getParam("cache_pairwise");
        String quiet_s = (String)gc.getParam("quiet");
        if (benchSize_s != null) {
            try {
                this.benchSize = Integer.parseInt(benchSize_s);
            }
            catch (NumberFormatException e) {
                throw new SLIB_Ex_Critic("Error converting bench_size to an integer value ");
            }
        }
        if (cache_pairwise_s != null) {
            this.cachePairwiseResults = Util.stringToBoolean(cache_pairwise_s) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (quiet_s != null) {
            this.quiet = Util.stringToBoolean(quiet_s);
        }
    }

    private LinkedHashSet<ICconf> buildICconf(LinkedHashSet<Conf> gCong) throws SLIB_Ex_Critic {
        LinkedHashSet<ICconf> icConfSet = new LinkedHashSet<ICconf>();
        String[] defaultAttributs = new String[]{"id", "label", "flag", "kb"};
        for (Conf c : gCong) {
            String id = (String)c.getParam("id");
            String label = (String)c.getParam("label");
            String flag = (String)c.getParam("flag");
            if (id == null) {
                id = flag;
            }
            if (label == null) {
                label = id;
            }
            ICconf ic = null;
            if (SMConstants.SIM_PAIRWISE_DAG_NODE_IC_INTRINSIC.containsKey(flag)) {
                ic = new IC_Conf_Topo(id, label, flag);
            } else if (SMConstants.SIM_PAIRWISE_DAG_NODE_IC_ANNOT.containsKey(flag)) {
                ic = new IC_Conf_Corpus(id, label, flag);
            } else {
                throw new SLIB_Ex_Critic("Cannot resolve IC flag: " + flag);
            }
            ic = this.addExtraAttributs(defaultAttributs, c, ic);
            for (ICconf m : icConfSet) {
                if (!m.getId().equals(ic.getId())) continue;
                throw new SLIB_Ex_Critic("Duplicate id for IC " + ic.getId());
            }
            icConfSet.add(ic);
        }
        return icConfSet;
    }

    public Integer getBenchSize() {
        return this.benchSize;
    }

    public Boolean getCachePairwiseResults() {
        return this.cachePairwiseResults;
    }

    public boolean isQuiet() {
        return this.quiet;
    }
}

