/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.smltoolkit.sm.cli.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import slib.sml.sm.core.utils.SMConstants;
import slib.tools.smltoolkit.sm.cli.core.utils.SML_SM_module_XML_block_conf;
import slib.utils.ex.SLIB_Ex_Critic;

public class XMLConfUtils {
    public static String buildSML_FilterGAF2_XML_block(String filterConfAsString) throws SLIB_Ex_Critic {
        if (filterConfAsString == null) {
            return "";
        }
        ArrayList<String> listParams = new ArrayList<String>(Arrays.asList(filterConfAsString.split(":")));
        String conf = "";
        String remove_ecAtt = null;
        String taxonAtt = null;
        for (String s : listParams) {
            String[] data = s.split("=");
            if (data[0].equals("noEC")) {
                if (data.length != 2) continue;
                remove_ecAtt = "remove_ec=\"" + data[1] + "\"";
                continue;
            }
            if (data[0].equals("Taxon")) {
                if (data.length != 2) continue;
                taxonAtt = "tax_ids=\"" + data[1] + "\"";
                continue;
            }
            throw new SLIB_Ex_Critic("Cannot process the filter parameters in " + s + " please consult the documentation");
        }
        if (remove_ecAtt != null || taxonAtt != null) {
            conf = conf + "\t\t<filter\n";
            conf = conf + "\t\t\tid = \"filter_gaf_2\"\n";
            conf = conf + "\t\t\ttype = \"GAF2\"\n";
            if (remove_ecAtt != null) {
                conf = conf + "\t\t\t" + remove_ecAtt + "\n";
            }
            if (taxonAtt != null) {
                conf = conf + "\t\t\t" + taxonAtt + "\n";
            }
            conf = conf + "\t\t/>\n";
        }
        return conf;
    }

    public static String buildSML_SM_module_XML_block_GO_PROFILE(SML_SM_module_XML_block_conf c) throws SLIB_Ex_Critic {
        String optModuleXML = "";
        String icXML = "";
        String pmXML = "";
        String gmXML = "";
        String queryXML = "";
        String icflag = null;
        String pmflag = null;
        String gmflag = null;
        optModuleXML = optModuleXML + "\t\t<opt_module threads=\"" + c.threads + "\" ";
        if (c.quiet != null) {
            optModuleXML = optModuleXML + "\tquiet = \"" + c.quiet + "\"\n";
        }
        optModuleXML = optModuleXML + "/>\n\n";
        if (c.icShortFlag != null) {
            if (SMConstants.IC_SHORT_FLAG.containsKey(c.icShortFlag)) {
                icflag = SMConstants.IC_SHORT_FLAG.get(c.icShortFlag);
                icXML = icXML + "\n\t\t<ics>\n\t\t\t<ic id   = \"" + c.icShortFlag + "\" flag = \"" + icflag + "\"  />\n";
            } else {
                throw new SLIB_Ex_Critic("The flag of the information content you selected '" + c.icShortFlag + "' cannot be associated to a measure, supported are " + SMConstants.IC_SHORT_FLAG.keySet());
            }
        }
        if (c.pmShortFlag != null) {
            if (SMConstants.SIM_PAIRWISE_SHORT_FLAG.containsKey(c.pmShortFlag)) {
                pmflag = SMConstants.SIM_PAIRWISE_SHORT_FLAG.get(c.pmShortFlag);
                String icAtt = "";
                if (icflag != null) {
                    icAtt = "ic = \"" + c.icShortFlag + "\" ";
                }
                if (c.pmShortFlag.equals("schlicker")) {
                    icXML = icXML + "\t\t\t<ic id   = \"ic_prob_propagatted\" flag = \"ICI_PROB_OCCURENCE_PROPAGATED\"  />\n";
                    icAtt = icAtt + " ic_prob = \"ic_prob_propagatted\"";
                }
                pmXML = pmXML + "\t\t<measures type = \"pairwise\">\n\t\t\t<measure   id   = \"" + c.pmShortFlag + "\" flag = \"" + pmflag + "\"  " + icAtt + " />\n\t\t</measures>\n\n";
            } else {
                throw new SLIB_Ex_Critic("The flag of the pairwise semantic measure you selected '" + c.pmShortFlag + "' cannot be associated to a measure, supported are " + SMConstants.SIM_PAIRWISE_SHORT_FLAG.keySet());
            }
        }
        if (c.gmShortFlag != null) {
            if (SMConstants.SIM_GROUPWISE_SHORT_FLAG.containsKey(c.gmShortFlag)) {
                gmflag = SMConstants.SIM_GROUPWISE_SHORT_FLAG.get(c.gmShortFlag);
                String pmAtt = "";
                if (pmflag != null) {
                    pmAtt = "pairwise_measure = \"" + c.pmShortFlag + "\"";
                }
                String icAtt = "";
                if (icflag != null && pmflag == null) {
                    icAtt = "ic = \"" + c.icShortFlag + "\"";
                }
                gmXML = gmXML + "\t\t<measures type = \"groupwise\">\n\t\t\t<measure   id   = \"" + c.gmShortFlag + "\" flag = \"" + gmflag + "\"  " + pmAtt + " " + icAtt + " />\n\t\t</measures>\n\n";
            } else {
                throw new SLIB_Ex_Critic("The flag of the groupwise semantic measure you selected '" + c.gmShortFlag + "' cannot be associated to a measure, supported are " + SMConstants.SIM_GROUPWISE_SHORT_FLAG.keySet());
            }
        }
        if (!icXML.isEmpty()) {
            icXML = icXML + "\t\t</ics>\n\n";
        }
        String mType = "cTOc";
        if (c.mtype != null && c.mtype.equals("g")) {
            mType = "oTOo";
            if (c.gmShortFlag == null) {
                throw new SLIB_Ex_Critic("Please precise a groupwise measure -gm (also using -pm if you want to use an indirect groupwise measure)");
            }
        } else if (c.pmShortFlag == null) {
            throw new SLIB_Ex_Critic("Please precise a pairwise measure -pm");
        }
        queryXML = queryXML + "\t\t<queries id= \"query\" \n\t\t\ttype    = \"" + mType + "\" \n\t\t\t" + "file" + "    = \"" + c.queries + "\" \n\t\t\t" + "output" + "  = \"" + c.output + "\" \n";
        if (c.noAnnots != null) {
            queryXML = queryXML + "\t\t\tnoAnnots = \"" + c.noAnnots + "\"\n";
        }
        if (c.notFound != null) {
            queryXML = queryXML + "\t\t\tnotFound = \"" + c.notFound + "\"\n";
        }
        if (c.mtype != null && c.mtype.equals("g")) {
            queryXML = queryXML + "\t\t\turi_prefix = \"" + c.prefixURI_Attr + "\"\n";
            queryXML = queryXML + "\t\t\toutput_basename = \"false\" \n";
        } else {
            queryXML = queryXML + "\t\t\tuse_uri_prefix = \"true\"\n";
            queryXML = queryXML + "\t\t\toutput_basename = \"true\" \n";
            queryXML = queryXML + "\t\t\tuse_uri_prefix_output = \"true\"\n";
        }
        queryXML = queryXML + "\t\t/>\n";
        String xmlconf = "\t<sml module=\"sm\" graph=\"" + c.graphURI + "\" >\n\n";
        xmlconf = xmlconf + optModuleXML;
        xmlconf = xmlconf + icXML;
        xmlconf = xmlconf + pmXML;
        xmlconf = xmlconf + gmXML;
        xmlconf = xmlconf + queryXML;
        xmlconf = xmlconf + "\t</sml>\n";
        return xmlconf;
    }

    public static String buildSML_SM_module_XML_block_MESH_PROFILE(SML_SM_module_XML_block_conf c) throws SLIB_Ex_Critic {
        String optModuleXML = "";
        String icXML = "";
        String pmXML = "";
        String gmXML = "";
        String queryXML = "";
        String icflag = null;
        String pmflag = null;
        String gmflag = null;
        optModuleXML = optModuleXML + "\t\t<opt_module threads=\"" + c.threads + "\" ";
        if (c.quiet != null) {
            optModuleXML = optModuleXML + "\tquiet = \"" + c.quiet + "\"\n";
        }
        optModuleXML = optModuleXML + "/>\n\n";
        if (c.icShortFlag != null) {
            if (SMConstants.IC_SHORT_FLAG.containsKey(c.icShortFlag)) {
                icflag = SMConstants.IC_SHORT_FLAG.get(c.icShortFlag);
                icXML = icXML + "\n\t\t<ics>\n\t\t\t<ic id   = \"" + c.icShortFlag + "\" flag = \"" + icflag + "\"  />\n";
            } else {
                throw new SLIB_Ex_Critic("The flag of the information content you selected '" + c.icShortFlag + "' cannot be associated to a measure, supported are " + SMConstants.IC_SHORT_FLAG.keySet());
            }
        }
        if (c.pmShortFlag != null) {
            if (SMConstants.SIM_PAIRWISE_SHORT_FLAG.containsKey(c.pmShortFlag)) {
                pmflag = SMConstants.SIM_PAIRWISE_SHORT_FLAG.get(c.pmShortFlag);
                String icAtt = "";
                if (icflag != null) {
                    icAtt = "ic = \"" + c.icShortFlag + "\" ";
                }
                if (c.pmShortFlag.equals("schlicker")) {
                    icXML = icXML + "\t\t\t<ic id   = \"ic_prob_propagatted\" flag = \"ICI_PROB_OCCURENCE_PROPAGATED\"  />\n";
                    icAtt = icAtt + " ic_prob = \"ic_prob_propagatted\"";
                }
                pmXML = pmXML + "\t\t<measures type = \"pairwise\">\n\t\t\t<measure   id   = \"" + c.pmShortFlag + "\" flag = \"" + pmflag + "\"  " + icAtt + " />\n\t\t</measures>\n\n";
            } else {
                throw new SLIB_Ex_Critic("The flag of the pairwise semantic measure you selected '" + c.pmShortFlag + "' cannot be associated to a measure, supported are " + SMConstants.SIM_PAIRWISE_SHORT_FLAG.keySet());
            }
        }
        if (c.gmShortFlag != null) {
            if (SMConstants.SIM_GROUPWISE_SHORT_FLAG.containsKey(c.gmShortFlag)) {
                gmflag = SMConstants.SIM_GROUPWISE_SHORT_FLAG.get(c.gmShortFlag);
                String pmAtt = "";
                if (pmflag != null) {
                    pmAtt = "pairwise_measure = \"" + c.pmShortFlag + "\"";
                }
                String icAtt = "";
                if (icflag != null && pmflag == null) {
                    icAtt = "ic = \"" + c.icShortFlag + "\"";
                }
                gmXML = gmXML + "\t\t<measures type = \"groupwise\">\n\t\t\t<measure   id   = \"" + c.gmShortFlag + "\" flag = \"" + gmflag + "\"  " + pmAtt + " " + icAtt + " />\n\t\t</measures>\n\n";
            } else {
                throw new SLIB_Ex_Critic("The flag of the groupwise semantic measure you selected '" + c.gmShortFlag + "' cannot be associated to a measure, supported are " + SMConstants.SIM_GROUPWISE_SHORT_FLAG.keySet());
            }
        }
        if (!icXML.isEmpty()) {
            icXML = icXML + "\t\t</ics>\n\n";
        }
        String mType = "cTOc";
        if (c.mtype != null && c.mtype.equals("g")) {
            mType = "oTOo";
            if (c.gmShortFlag == null) {
                throw new SLIB_Ex_Critic("Please precise a groupwise measure -gm (also using -pm if you want to use an indirect groupwise measure)");
            }
        } else if (c.pmShortFlag == null) {
            throw new SLIB_Ex_Critic("Please precise a pairwise measure -pm");
        }
        queryXML = queryXML + "\t\t<queries id= \"query\" \n\t\t\ttype    = \"" + mType + "\" \n\t\t\t" + "file" + "    = \"" + c.queries + "\" \n\t\t\t" + "output" + "  = \"" + c.output + "\" \n";
        if (c.noAnnots != null) {
            queryXML = queryXML + "\t\t\tnoAnnots = \"" + c.noAnnots + "\"\n";
        }
        if (c.notFound != null) {
            queryXML = queryXML + "\t\t\tnotFound = \"" + c.notFound + "\"\n";
        }
        if (c.mtype != null && c.mtype.equals("g")) {
            queryXML = queryXML + "\t\t\turi_prefix = \"" + c.prefixURI_Attr + "\"\n";
            queryXML = queryXML + "\t\t\toutput_basename = \"false\" \n";
        } else {
            queryXML = queryXML + "\t\t\turi_prefix = \"" + c.prefixURI_Attr + "\"\n";
            queryXML = queryXML + "\t\t\toutput_basename = \"false\" \n";
        }
        queryXML = queryXML + "\t\t/>\n";
        String xmlconf = "\t<sml module=\"sm\" graph=\"" + c.graphURI + "\" >\n\n";
        xmlconf = xmlconf + optModuleXML;
        xmlconf = xmlconf + icXML;
        xmlconf = xmlconf + pmXML;
        xmlconf = xmlconf + gmXML;
        xmlconf = xmlconf + queryXML;
        xmlconf = xmlconf + "\t</sml>\n";
        return xmlconf;
    }
}

