/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.smltoolkit.sm.cli.profile.go;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import slib.graph.io.util.GFormat;
import slib.tools.module.ToolCmdHandlerCst;

public class SmProfileGOCst
extends ToolCmdHandlerCst {
    private static final String _moduleName = "sm";
    private static final String _appCmdName = "sml-toolkit-<version>.jar  -t sm -profile GO";
    private static boolean _debugMode = false;
    static String ANNOTSFORMAT_DEFAULT = "GAF2";
    static String GOFORMAT_DEFAULT = "OBO";
    static String GOFORMAT_OWL = "OWL";
    static String[] GOFORMAT_VALID = new String[]{GFormat.OBO.name(), GOFORMAT_OWL, GFormat.RDF_XML.name()};
    static String MTYPE_PAIRWISE = "p";
    static String MTYPE_GROUPWISE = "g";
    static String MTYPE_DEFAULT = "p";
    static String ASPECT_DEFAULT = "BP";
    static String NOTFOUND_DEFAULT = "exclude";
    static String NOANNOTS_DEFAULT = "set=-1";
    static String THREADS_DEFAULT = "1";
    public static final String errorMissingXMLconfOrProfile = "[ERROR] Please specify a profile or an Xml configuration file";
    private static final Option _go;
    private static final Option _go_format;
    private static final Option _annots;
    private static final Option _annotsFormat;
    private static final Option _queries;
    private static final Option _output;
    private static final Option _mtype;
    private static final Option _aspect;
    private static final Option _notfound;
    private static final Option _noannots;
    private static final Option _filter;
    private static final Option _pm;
    private static final Option _gm;
    private static final Option _ic;
    private static final Option _quiet;
    private static final Option _notrgo;
    private static final Option _notrannots;
    private static final Option _threads;
    private static final Map<Option, Integer> _optionsOrder;

    public SmProfileGOCst() {
        super(_appCmdName, _debugMode, _optionsOrder);
    }

    static {
        OptionBuilder.withArgName("file path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nThe path to the GO (required)\n");
        _go = OptionBuilder.create("go");
        OptionBuilder.withArgName("format");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nThe ontology file format " + Arrays.toString(GOFORMAT_VALID) + ", default " + GOFORMAT_DEFAULT + "\n");
        _go_format = OptionBuilder.create("goformat");
        OptionBuilder.withArgName("file path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nThe path to the annotation file. Required for groupwise measures (-mtype g see above) or any measure relying on a extrinsic metric (e.g. Resnik's Information Content)");
        _annots = OptionBuilder.create("annots");
        OptionBuilder.withArgName("format");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nThe format of the annotation file, accepted values [GAF2,TSV], default GAF2");
        _annotsFormat = OptionBuilder.create("annotsFormat");
        OptionBuilder.withArgName("file path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nThe path to the file containing the queries, i.e. the pairs of GO term or gene product ids separated by tabs (required). An example is provided above.");
        _queries = OptionBuilder.create("queries");
        OptionBuilder.withArgName("file path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nOutput file to store the results (required)");
        _output = OptionBuilder.create("output");
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nThe type of semantic measures you want to use:\n- 'p' (pairwise) to compute semantic measures between GO terms.\n- 'g' (groupwise) to compute semantic measures between gene products.\naccepted values [p,g], default p\nexample -mtype p");
        _mtype = OptionBuilder.create("mtype");
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nSpecify the aspect of the GO to use:\n- 'MF'  Molecular Function\n- 'BP'  Biological Process\n- 'CC'  Cellular Component\n- 'GLOBAL'  the three aspects MF-BP-CC will be used using a virtual root between the three\n- 'custom=<GO term id>' specify a GO term which will be considered as root e.g. custom=GO:XXXXX.\naccepted values [MF,BP,CC,GLOBAL,custom=<GO term id>], default BP. examples (1) -aspect MF (2) -aspect custom=GO:XXXXX");
        _aspect = OptionBuilder.create("aspect");
        OptionBuilder.withArgName("flag");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nDefine the behavior if an entry element of the query file cannot be found: (i) in pairwise measures: one of the two GO terms cannot be found, (ii) in groupwise measures: one of the two gene products cannot be found. Accepted values [exclude, stop, set=<value>]:\n- 'exclude' the entry will not be processed (a message will be logged if -quiet is not used)\n- 'stop'    the program will stop\n- 'set=<value>' the entry will not be processed (a message will be logged if -quiet is not used).\ndefault value = 'exclude'");
        _notfound = OptionBuilder.create("notfound");
        OptionBuilder.withArgName("flag");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nDefine the behavior if a gene product of the query file doesn't have annotation (GO terms): Accepted values [exclude,stop, set=<value>]: Accepted values [exclude, stop, set=<value>]:\n- 'exclude' the entry will not be processed (a message will be logged if -quiet is not used)\n- 'stop'    the program will stop\n- 'set=<value>' the entry will not be processed (a message will be logged if -quiet is not used).\ndefault value 'set=0' the score is set to 0");
        _noannots = OptionBuilder.create("noannots");
        OptionBuilder.withArgName("params");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nThis parameter can be used to filter the GO terms associated to a gene product when the provided annotation file is in GAF2 format.\n- EC=<evidence_codes> evidence codes separated by commas e.g. EC=IEA only IEA annotations will be considered.\n- Taxon=<taxon_ids> taxon ids separated by commas e.g. Taxon=9696 to only consider annotations associated to Taxon 9696.\nExemple of value -filter EC=IEA,XXX:Taxon=9696.Default value no filter");
        _filter = OptionBuilder.create("filter");
        OptionBuilder.withArgName("flag");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nPairwise measure [ 'resnik', 'lin', 'schlicker', 'jc' ] (required for pairwise measures or indirect groupwise measures). See the complete list on the website.");
        _pm = OptionBuilder.create("pm");
        OptionBuilder.withArgName("flag");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nDirect groupwise measure [ 'to', 'nto', 'gic', 'ui', ... ] or aggregation method (mixing strategy) [ 'min', 'max', 'bma', 'bmm', ... ] if an indirect groupwise measure is be used (require a pairwise measure to be set). See the complete list on the website.");
        _gm = OptionBuilder.create("gm");
        OptionBuilder.withArgName("flag");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nInformation content method. Extrinsic (require annotation file): [ 'resnik' ], Intrinsic : [ 'sanchez', 'zhou', 'seco' ]. See the complete list on the website.");
        _ic = OptionBuilder.create("ic");
        OptionBuilder.withArgName("quiet");
        OptionBuilder.withDescription("\nDo not show warning messages");
        _quiet = OptionBuilder.create("quiet");
        OptionBuilder.withArgName("notrgo");
        OptionBuilder.withDescription("\nDo not perform a transitive reduction of the GO");
        _notrgo = OptionBuilder.create("notrgo");
        OptionBuilder.withArgName("notrannots");
        OptionBuilder.withDescription("\nDo not remove annotation redundancy i.e. if a gene product is annoted by two GO terms {X,Y} and X is subsumed by Y in the GO, the GO term Y will be removed from the annotations.");
        _notrannots = OptionBuilder.create("notrannots");
        OptionBuilder.withArgName("nb");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nInteger definying the number of threads to use, i.e. processes allocates to the execution, default 1.\n Setting more threads reduce execution time, suited configuration depends on tour computer, use with care if you don't get the implications in term of computational resources which will be used.");
        _threads = OptionBuilder.create("threads");
        _optionsOrder = new LinkedHashMap<Option, Integer>();
        _optionsOrder.put(_go, _optionsOrder.size());
        _optionsOrder.put(_go_format, _optionsOrder.size());
        _optionsOrder.put(_annots, _optionsOrder.size());
        _optionsOrder.put(_annotsFormat, _optionsOrder.size());
        _optionsOrder.put(_queries, _optionsOrder.size());
        _optionsOrder.put(_output, _optionsOrder.size());
        _optionsOrder.put(_mtype, _optionsOrder.size());
        _optionsOrder.put(_aspect, _optionsOrder.size());
        _optionsOrder.put(_notfound, _optionsOrder.size());
        _optionsOrder.put(_noannots, _optionsOrder.size());
        _optionsOrder.put(_filter, _optionsOrder.size());
        _optionsOrder.put(_pm, _optionsOrder.size());
        _optionsOrder.put(_gm, _optionsOrder.size());
        _optionsOrder.put(_ic, _optionsOrder.size());
        _optionsOrder.put(_quiet, _optionsOrder.size());
        _optionsOrder.put(_notrgo, _optionsOrder.size());
        _optionsOrder.put(_notrannots, _optionsOrder.size());
        _optionsOrder.put(_threads, _optionsOrder.size());
    }
}

