/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.smltoolkit.sm.cli.profile.go;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.io.util.GFormat;
import slib.tools.smltoolkit.SmlModuleCLI;
import slib.tools.smltoolkit.sm.cli.core.utils.SML_SM_module_XML_block_conf;
import slib.tools.smltoolkit.sm.cli.core.utils.XMLConfUtils;
import slib.tools.smltoolkit.sm.cli.profile.go.SmProfileGOCst;
import slib.tools.smltoolkit.sm.cli.profile.go.SmProfileGOHandler;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.Util;

public class SmProfile_GO
implements SmlModuleCLI {
    Logger logger = LoggerFactory.getLogger(SmProfile_GO.class);
    public String xmlconf;

    @Override
    public void execute(String[] args) throws SLIB_Exception {
        block34: {
            SmProfileGOHandler c = new SmProfileGOHandler();
            c.processArgs(args);
            try {
                String goAspectValue;
                String GRAPH_URI;
                SML_SM_module_XML_block_conf smconf = c.getSmconf();
                boolean performGroupwise = smconf.mtype.equals(SmProfileGOCst.MTYPE_GROUPWISE);
                this.logger.info("Parameters");
                this.logger.info("---------------------------------------------------------------");
                this.logger.info("mType        : " + smconf.mtype);
                this.logger.info("Ontology     : " + smconf.ontologyPath);
                this.logger.info("Onto format  : " + smconf.ontologyFormat);
                this.logger.info("Aspect       : " + smconf.aspect);
                this.logger.info("Annots       : " + smconf.annotsPath);
                this.logger.info("Annot Format : " + smconf.annotsFormat);
                if (performGroupwise) {
                    this.logger.info("notfound     : " + smconf.notFound);
                    this.logger.info("noannots     : " + smconf.noAnnots);
                    this.logger.info("filter       : " + smconf.filter);
                }
                this.logger.info("Queries      : " + smconf.queries);
                this.logger.info("Output       : " + smconf.output);
                this.logger.info("pm           : " + smconf.pmShortFlag);
                this.logger.info("ic           : " + smconf.icShortFlag);
                if (performGroupwise) {
                    this.logger.info("gm           : " + smconf.gmShortFlag);
                }
                this.logger.info("quiet        : " + Util.stringToBoolean(smconf.quiet));
                this.logger.info("threads      : " + smconf.threads);
                this.logger.info("notrgo       : " + Util.stringToBoolean(smconf.notrkr));
                this.logger.info("nonotrannots : " + Util.stringToBoolean(smconf.notrannots));
                this.logger.info("---------------------------------------------------------------");
                if (smconf.ontologyPath == null) {
                    throw new SLIB_Ex_Critic("Please precise the location of the ontology");
                }
                if (smconf.ontologyFormat == null) {
                    smconf.setOntologyFormat(SmProfileGOCst.GOFORMAT_DEFAULT);
                } else {
                    if (!Arrays.asList(SmProfileGOCst.GOFORMAT_VALID).contains(smconf.ontologyFormat)) {
                        throw new SLIB_Ex_Critic("Please precise a valid ontology format, current '" + smconf.ontologyFormat + "' valid= " + Arrays.toString(SmProfileGOCst.GOFORMAT_VALID));
                    }
                    if (smconf.ontologyFormat.equals(SmProfileGOCst.GOFORMAT_OWL)) {
                        smconf.setOntologyFormat(GFormat.RDF_XML.name());
                    }
                }
                if (smconf.queries == null) {
                    throw new SLIB_Ex_Critic("Please precise the location of the queries");
                }
                if (smconf.output == null) {
                    throw new SLIB_Ex_Critic("Please precise the location of the output file");
                }
                try {
                    if (Integer.parseInt(smconf.threads) < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    throw new SLIB_Ex_Critic("Please correct the number of threads allocated");
                }
                String GO_PREFIX = "http://purl.org/obo/owl/GO#";
                String GO_PREFIX_OWL = "http://purl.obolibrary.org/obo/GO_";
                String GENE_ID_PREFIX = GRAPH_URI = "http://bio/";
                smconf.setGraphURI(GRAPH_URI);
                smconf.setPrefixURIAttribut(GENE_ID_PREFIX);
                this.xmlconf = "<sglib>\n";
                this.xmlconf = this.xmlconf + "\t<opt  threads = \"" + smconf.threads + "\"  />\n\n";
                if (smconf.ontologyFormat.equals("RDF_XML")) {
                    GO_PREFIX = GO_PREFIX_OWL;
                }
                this.xmlconf = this.xmlconf + "\t<namespaces>\n\t\t<nm prefix=\"GO\" ref=\"" + GO_PREFIX + "\" />\n\t</namespaces>\n\n";
                this.xmlconf = this.xmlconf + "\t<graphs>    \n";
                this.xmlconf = this.xmlconf + "\t\t<graph uri=\"" + smconf.graphURI + "\"  >    \n";
                this.xmlconf = this.xmlconf + "\t\t\t<data>\n";
                this.xmlconf = this.xmlconf + "\t\t\t\t<file format=\"" + smconf.ontologyFormat + "\"   path=\"" + smconf.ontologyPath + "\"/>    \n";
                if (smconf.annotsPath != null) {
                    if (smconf.annotsFormat == null || smconf.annotsFormat.equals("GAF2")) {
                        smconf.setAnnotsFormat("GAF2");
                        this.xmlconf = this.xmlconf + "\t\t\t\t<file format=\"" + smconf.annotsFormat + "\"   path=\"" + smconf.annotsPath + "\"/>    \n";
                    } else if (smconf.annotsFormat.equals("TSV")) {
                        this.xmlconf = this.xmlconf + "\t\t\t\t<file format=\"TSV_ANNOT\"   path=\"" + smconf.annotsPath + "\" prefixSubject=\"" + GENE_ID_PREFIX + "\" header=\"false\"/>    \n";
                    } else {
                        throw new SLIB_Ex_Critic("Unsupported file format " + smconf.annotsFormat);
                    }
                }
                this.xmlconf = this.xmlconf + "\t\t\t</data>\n\n";
                String actions = "";
                String actionValue = "VERTICES_REDUCTION";
                String GO_LOCAL_NAME_PREFIX = "";
                if (smconf.aspect == null || smconf.aspect.equals("BP")) {
                    goAspectValue = GO_PREFIX + GO_LOCAL_NAME_PREFIX + "0008150";
                } else if (smconf.aspect.equals("MF")) {
                    goAspectValue = GO_PREFIX + GO_LOCAL_NAME_PREFIX + "0003674";
                } else if (smconf.aspect.equals("CC")) {
                    goAspectValue = GO_PREFIX + GO_LOCAL_NAME_PREFIX + "0005575";
                } else if (smconf.aspect.equals("GLOBAL")) {
                    goAspectValue = "__FICTIVE__";
                    actionValue = "REROOTING";
                } else {
                    String[] data = smconf.aspect.split("=");
                    if (data.length != 2) {
                        throw new SLIB_Ex_Critic("Cannot process the value " + smconf.aspect + " as a valid aspect for the GO");
                    }
                    goAspectValue = data[1];
                    goAspectValue = goAspectValue.trim();
                }
                actions = actions + "\t\t\t\t<action type=\"" + actionValue + "\" root_uri=\"" + goAspectValue + "\" />\n";
                if (!Util.stringToBoolean(smconf.notrkr)) {
                    actions = actions + "\t\t\t\t<action type=\"TRANSITIVE_REDUCTION\" target=\"CLASSES\" />\n";
                }
                if (smconf.annotsPath != null && !Util.stringToBoolean(smconf.notrannots)) {
                    actions = actions + "\t\t\t\t<action type=\"TRANSITIVE_REDUCTION\" target=\"INSTANCES\" />\n";
                }
                if (!actions.isEmpty()) {
                    this.xmlconf = this.xmlconf + "\t\t\t<actions>\n" + actions + "\t\t\t</actions>\n";
                }
                this.xmlconf = this.xmlconf + "\t\t</graph>    \n";
                this.xmlconf = this.xmlconf + "\t</graphs>\n\n";
                if (smconf.filter != null) {
                    if (!smconf.annotsFormat.equals(GFormat.GAF2.toString())) {
                        throw new SLIB_Ex_Critic("Filtering can only be performed on annotation file of type " + GFormat.GAF2.toString());
                    }
                    this.xmlconf = this.xmlconf + "\t<filters>\n" + XMLConfUtils.buildSML_FilterGAF2_XML_block(smconf.filter) + "\t</filters>\n";
                }
                this.xmlconf = this.xmlconf + XMLConfUtils.buildSML_SM_module_XML_block_GO_PROFILE(smconf);
                this.xmlconf = this.xmlconf + "</sglib>\n";
                this.logger.info("XML configuration file generated");
                this.logger.info(this.xmlconf);
                this.logger.info("---------------------------------------------------------------");
            }
            catch (Exception e) {
                c.ending(e.getMessage(), true, false, true);
                if (!this.logger.isDebugEnabled()) break block34;
                e.printStackTrace();
            }
        }
    }
}

