/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.smltoolkit.sm.cli.profile.mesh;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.tools.smltoolkit.SmlModuleCLI;
import slib.tools.smltoolkit.sm.cli.core.utils.SML_SM_module_XML_block_conf;
import slib.tools.smltoolkit.sm.cli.core.utils.XMLConfUtils;
import slib.tools.smltoolkit.sm.cli.profile.mesh.SmProfileMeSHCst;
import slib.tools.smltoolkit.sm.cli.profile.mesh.SmProfileMeSHHandler;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.Util;

public class SmProfile_MeSH
implements SmlModuleCLI {
    Logger logger = LoggerFactory.getLogger(SmProfile_MeSH.class);
    public String xmlconf;

    @Override
    public void execute(String[] args) throws SLIB_Exception {
        block13: {
            this.logger.info("Init command-line parser...");
            SmProfileMeSHHandler c = new SmProfileMeSHHandler(args);
            c.processArgs(args);
            try {
                this.logger.info("Parsing command-line...");
                SML_SM_module_XML_block_conf smconf = c.getSmconf();
                this.logger.info("Parameters");
                this.logger.info("---------------------------------------------------------------");
                this.logger.info("mType        : " + smconf.mtype);
                this.logger.info("Ontology     : " + smconf.ontologyPath);
                boolean performGroupwise = smconf.mtype.equals(SmProfileMeSHCst.MTYPE_GROUPWISE);
                if (performGroupwise) {
                    this.logger.info("Annots       : " + smconf.annotsPath);
                    this.logger.info("Annot Format : " + smconf.annotsFormat);
                    this.logger.info("notfound     : " + smconf.notFound);
                    this.logger.info("noannots     : " + smconf.noAnnots);
                    this.logger.info("filter       : " + smconf.filter);
                }
                this.logger.info("Queries      : " + smconf.queries);
                this.logger.info("Output       : " + smconf.output);
                this.logger.info("pm           : " + smconf.pmShortFlag);
                this.logger.info("ic           : " + smconf.icShortFlag);
                if (performGroupwise) {
                    this.logger.info("gm           : " + smconf.gmShortFlag);
                }
                this.logger.info("quiet        : " + Util.stringToBoolean(smconf.quiet));
                this.logger.info("threads      : " + smconf.threads);
                this.logger.info("notrkr       : " + Util.stringToBoolean(smconf.notrkr));
                this.logger.info("nonotrannots : " + Util.stringToBoolean(smconf.notrannots));
                this.logger.info("---------------------------------------------------------------");
                if (smconf.ontologyPath == null) {
                    throw new SLIB_Ex_Critic("Please precise the location of the ontology");
                }
                if (smconf.queries == null) {
                    throw new SLIB_Ex_Critic("Please precise the location of the queries");
                }
                if (smconf.output == null) {
                    throw new SLIB_Ex_Critic("Please precise the location of the output file");
                }
                try {
                    if (Integer.parseInt(smconf.threads) < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    throw new SLIB_Ex_Critic("Please correct the number of threads allocated");
                }
                smconf.setGraphURI("http://g/");
                this.xmlconf = "<sglib>\n";
                this.xmlconf = this.xmlconf + "\t<opt  threads = \"" + smconf.threads + "\"  />\n\n";
                this.xmlconf = this.xmlconf + "\t<graphs>    \n";
                this.xmlconf = this.xmlconf + "\t\t<graph uri=\"" + smconf.graphURI + "\"  >    \n";
                this.xmlconf = this.xmlconf + "\t\t\t<data>\n";
                this.xmlconf = this.xmlconf + "\t\t\t\t<file format=\"MESH_XML\"   path=\"" + smconf.ontologyPath + "\"/>    \n";
                if (smconf.annotsPath != null) {
                    if (smconf.annotsFormat.equals("TSV")) {
                        this.xmlconf = this.xmlconf + "\t\t\t\t<file format=\"TSV_ANNOT\"   path=\"" + smconf.annotsPath + "\" prefixSubject=\"" + smconf.graphURI + "\"  prefixObject=\"" + smconf.graphURI + "\" header=\"false\"/>    \n";
                    } else {
                        throw new SLIB_Ex_Critic("Unsupported file format " + smconf.annotsFormat);
                    }
                }
                this.xmlconf = this.xmlconf + "\t\t\t</data>\n\n";
                this.xmlconf = this.xmlconf + "\t\t</graph>    \n";
                this.xmlconf = this.xmlconf + "\t</graphs>\n\n";
                smconf.setPrefixURIAttribut(smconf.graphURI);
                this.xmlconf = this.xmlconf + XMLConfUtils.buildSML_SM_module_XML_block_MESH_PROFILE(smconf);
                this.xmlconf = this.xmlconf + "</sglib>\n";
                this.logger.info("XML configuration file generated");
                this.logger.info(this.xmlconf);
                this.logger.info("---------------------------------------------------------------");
            }
            catch (SLIB_Ex_Critic e) {
                c.ending("Error processing configuration: " + e.getMessage(), true, false, true);
                if (!this.logger.isDebugEnabled()) break block13;
                e.printStackTrace();
            }
        }
    }
}

