/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.datetime;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;

public class Now
implements Function {
    @Override
    public String getURI() {
        return "NOW";
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 0) {
            throw new ValueExprEvaluationException("NOW requires 0 argument, got " + args.length);
        }
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(now);
        try {
            XMLGregorianCalendar date = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
            return valueFactory.createLiteral(date);
        }
        catch (DatatypeConfigurationException e) {
            throw new ValueExprEvaluationException(e);
        }
    }
}

