/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.algebra.helpers.VarNameCollector;

public class FilterOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new FilterFinder(tupleExpr));
    }

    protected static class FilterRelocator
    extends QueryModelVisitorBase<RuntimeException> {
        protected final Filter filter;
        protected final Set<String> filterVars;

        public static void relocate(Filter filter) {
            filter.visit(new FilterRelocator(filter));
        }

        public FilterRelocator(Filter filter) {
            this.filter = filter;
            this.filterVars = VarNameCollector.process(filter.getCondition());
        }

        @Override
        protected void meetNode(QueryModelNode node) {
            assert (node instanceof TupleExpr);
            this.relocate(this.filter, (TupleExpr)node);
        }

        @Override
        public void meet(Join join) {
            if (join.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                join.getLeftArg().visit(this);
            } else if (join.getRightArg().getBindingNames().containsAll(this.filterVars)) {
                join.getRightArg().visit(this);
            } else {
                this.relocate(this.filter, join);
            }
        }

        @Override
        public void meet(LeftJoin leftJoin) {
            if (leftJoin.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                leftJoin.getLeftArg().visit(this);
            } else {
                this.relocate(this.filter, leftJoin);
            }
        }

        @Override
        public void meet(Union union) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, union.getLeftArg());
            this.relocate(clone, union.getRightArg());
            FilterRelocator.relocate(this.filter);
            FilterRelocator.relocate(clone);
        }

        @Override
        public void meet(Difference node) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, node.getLeftArg());
            this.relocate(clone, node.getRightArg());
            FilterRelocator.relocate(this.filter);
            FilterRelocator.relocate(clone);
        }

        @Override
        public void meet(Intersection node) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, node.getLeftArg());
            this.relocate(clone, node.getRightArg());
            FilterRelocator.relocate(this.filter);
            FilterRelocator.relocate(clone);
        }

        @Override
        public void meet(Extension node) {
            if (node.getArg().getBindingNames().containsAll(this.filterVars)) {
                node.getArg().visit(this);
            } else {
                this.relocate(this.filter, node);
            }
        }

        @Override
        public void meet(EmptySet node) {
            if (this.filter.getParentNode() != null) {
                this.filter.replaceWith(this.filter.getArg());
            }
        }

        @Override
        public void meet(Filter filter) {
            filter.getArg().visit(this);
        }

        @Override
        public void meet(Distinct node) {
            node.getArg().visit(this);
        }

        @Override
        public void meet(Order node) {
            node.getArg().visit(this);
        }

        @Override
        public void meet(QueryRoot node) {
            node.getArg().visit(this);
        }

        @Override
        public void meet(Reduced node) {
            node.getArg().visit(this);
        }

        protected void relocate(Filter filter, TupleExpr newFilterArg) {
            if (filter.getArg() != newFilterArg) {
                if (filter.getParentNode() != null) {
                    filter.replaceWith(filter.getArg());
                }
                newFilterArg.replaceWith(filter);
                filter.setArg(newFilterArg);
            }
        }
    }

    protected static class FilterFinder
    extends QueryModelVisitorBase<RuntimeException> {
        protected final TupleExpr tupleExpr;

        public FilterFinder(TupleExpr tupleExpr) {
            this.tupleExpr = tupleExpr;
        }

        @Override
        public void meet(Filter filter) {
            super.meet(filter);
            FilterRelocator.relocate(filter);
        }
    }
}

