/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.AggregateOperator;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;

public class ExtensionIterator
extends ConvertingIteration<BindingSet, BindingSet, QueryEvaluationException> {
    private final Extension extension;
    private final EvaluationStrategy strategy;

    public ExtensionIterator(Extension extension, CloseableIteration<BindingSet, QueryEvaluationException> iter, EvaluationStrategy strategy) throws QueryEvaluationException {
        super(iter);
        this.extension = extension;
        this.strategy = strategy;
    }

    @Override
    public BindingSet convert(BindingSet sourceBindings) throws QueryEvaluationException {
        QueryBindingSet targetBindings = new QueryBindingSet(sourceBindings);
        for (ExtensionElem extElem : this.extension.getElements()) {
            ValueExpr expr = extElem.getExpr();
            if (expr instanceof AggregateOperator) continue;
            try {
                Value targetValue = this.strategy.evaluate(extElem.getExpr(), (BindingSet)targetBindings);
                if (targetValue == null) continue;
                targetBindings.setBinding(extElem.getName(), targetValue);
            }
            catch (ValueExprEvaluationException e) {}
        }
        return targetBindings;
    }
}

