/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql;

import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.SingletonIteration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.query.parser.sparql.SPARQLUtil;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.UnknownTransactionStateException;
import org.openrdf.repository.base.RepositoryConnectionBase;
import org.openrdf.repository.sparql.SPARQLRepository;
import org.openrdf.repository.sparql.query.SPARQLBooleanQuery;
import org.openrdf.repository.sparql.query.SPARQLGraphQuery;
import org.openrdf.repository.sparql.query.SPARQLTupleQuery;
import org.openrdf.repository.sparql.query.SPARQLUpdate;
import org.openrdf.repository.util.RDFLoader;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.StatementCollector;

public class SPARQLConnection
extends RepositoryConnectionBase {
    private static final String EVERYTHING = "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }";
    private static final String SOMETHING = "ASK { ?s ?p ?o }";
    private static final String NAMEDGRAPHS = "SELECT DISTINCT ?_ WHERE { GRAPH ?_ { ?s ?p ?o } }";
    private StringBuffer sparqlTransaction;
    private Object transactionLock = new Object();

    public SPARQLConnection(SPARQLRepository repository) {
        super(repository);
    }

    public String toString() {
        return this.getRepository().getHTTPClient().getQueryURL();
    }

    @Override
    public void exportStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        try {
            GraphQuery query = this.prepareGraphQuery(QueryLanguage.SPARQL, EVERYTHING, "");
            this.setBindings(query, subj, pred, obj, contexts);
            query.evaluate(handler);
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException(e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            TupleQuery query = this.prepareTupleQuery(QueryLanguage.SPARQL, NAMEDGRAPHS, "");
            TupleQueryResult result = query.evaluate();
            return new RepositoryResult<Resource>(new ExceptionConvertingIteration<Resource, RepositoryException>((Iteration)new ConvertingIteration<BindingSet, Resource, QueryEvaluationException>((Iteration)result){

                @Override
                protected Resource convert(BindingSet bindings) throws QueryEvaluationException {
                    return (Resource)bindings.getValue("_");
                }
            }){

                @Override
                protected RepositoryException convert(Exception e) {
                    return new RepositoryException(e);
                }
            });
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException(e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public String getNamespace(String prefix) throws RepositoryException {
        return null;
    }

    @Override
    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        return new RepositoryResult<Namespace>(new EmptyIteration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(Resource ... contexts) throws RepositoryException {
        RepositoryResult<Statement> stmts = this.getStatements(null, null, null, true, contexts);
        try {
            long i = 0L;
            while (stmts.hasNext()) {
                stmts.next();
                ++i;
            }
            long l = i;
            return l;
        }
        finally {
            stmts.close();
        }
    }

    @Override
    public RepositoryResult<Statement> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            if (subj != null && pred != null && obj != null) {
                if (this.hasStatement(subj, pred, obj, includeInferred, contexts)) {
                    StatementImpl st = new StatementImpl(subj, pred, obj);
                    SingletonIteration cursor = new SingletonIteration(st);
                    return new RepositoryResult<Statement>(cursor);
                }
                return new RepositoryResult<Statement>(new EmptyIteration());
            }
            GraphQuery query = this.prepareGraphQuery(QueryLanguage.SPARQL, EVERYTHING, "");
            this.setBindings(query, subj, pred, obj, contexts);
            GraphQueryResult result = query.evaluate();
            return new RepositoryResult<Statement>(new ExceptionConvertingIteration<Statement, RepositoryException>((Iteration)result){

                @Override
                protected RepositoryException convert(Exception e) {
                    return new RepositoryException(e);
                }
            });
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException(e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public boolean hasStatement(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            BooleanQuery query = this.prepareBooleanQuery(QueryLanguage.SPARQL, SOMETHING, "");
            this.setBindings(query, subj, pred, obj, contexts);
            return query.evaluate();
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException(e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public SPARQLRepository getRepository() {
        return (SPARQLRepository)super.getRepository();
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals(ql)) {
            String strippedQuery = QueryParserUtil.removeSPARQLQueryProlog(query).toUpperCase();
            if (strippedQuery.startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, query, base);
            }
            if (strippedQuery.startsWith("ASK")) {
                return this.prepareBooleanQuery(ql, query, base);
            }
            return this.prepareGraphQuery(ql, query, base);
        }
        throw new UnsupportedOperationException("Unsupported query language " + ql);
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals(ql)) {
            return new SPARQLBooleanQuery(this.getRepository().getHTTPClient(), base, query);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals(ql)) {
            return new SPARQLGraphQuery(this.getRepository().getHTTPClient(), base, query);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String base) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals(ql)) {
            return new SPARQLTupleQuery(this.getRepository().getHTTPClient(), base, query);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws RepositoryException {
        Object object = this.transactionLock;
        synchronized (object) {
            if (this.isActive()) {
                Object object2 = this.transactionLock;
                synchronized (object2) {
                    SPARQLUpdate transaction = new SPARQLUpdate(this.getRepository().getHTTPClient(), null, this.sparqlTransaction.toString());
                    try {
                        transaction.execute();
                    }
                    catch (UpdateExecutionException e) {
                        throw new RepositoryException("error executing transaction", e);
                    }
                    this.sparqlTransaction = null;
                }
            }
            throw new RepositoryException("no transaction active.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws RepositoryException {
        Object object = this.transactionLock;
        synchronized (object) {
            if (this.isActive()) {
                Object object2 = this.transactionLock;
                synchronized (object2) {
                    this.sparqlTransaction = null;
                }
            } else {
                throw new RepositoryException("no transaction active.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() throws RepositoryException {
        Object object = this.transactionLock;
        synchronized (object) {
            if (!this.isActive()) {
                Object object2 = this.transactionLock;
                synchronized (object2) {
                    this.sparqlTransaction = new StringBuffer();
                }
            } else {
                throw new RepositoryException("active transaction already exists");
            }
        }
    }

    @Override
    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        StatementCollector collector = new StatementCollector();
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(file, baseURI, dataFormat, (RDFHandler)collector);
            this.add(collector.getStatements(), contexts);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        StatementCollector collector = new StatementCollector();
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(url, baseURI, dataFormat, (RDFHandler)collector);
            this.add(collector.getStatements(), contexts);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        StatementCollector collector = new StatementCollector();
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(in, baseURI, dataFormat, (RDFHandler)collector);
            this.add(collector.getStatements(), contexts);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        StatementCollector collector = new StatementCollector();
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(reader, baseURI, dataFormat, (RDFHandler)collector);
            this.add(collector.getStatements(), contexts);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        ArrayList<Statement> list = new ArrayList<Statement>(1);
        list.add(st);
        String sparqlCommand = this.createInsertDataCommand(list, contexts);
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
        try {
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        String sparqlCommand = this.createInsertDataCommand(statements, contexts);
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
        try {
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        boolean localTransaction = this.startLocalTransaction();
        if (contexts.length == 0) {
            this.sparqlTransaction.append("CLEAR ALL ");
            this.sparqlTransaction.append("; ");
        } else {
            for (Resource context : contexts) {
                if (context == null) {
                    this.sparqlTransaction.append("CLEAR DEFAULT ");
                    this.sparqlTransaction.append("; ");
                    continue;
                }
                if (context instanceof URI) {
                    this.sparqlTransaction.append("CLEAR GRAPH <" + context.stringValue() + "> ");
                    this.sparqlTransaction.append("; ");
                    continue;
                }
                throw new RepositoryException("SPARQL does not support named graphs identified by blank nodes.");
            }
        }
        try {
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void clearNamespaces() throws RepositoryException {
    }

    @Override
    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        ArrayList<Statement> list = new ArrayList<Statement>(1);
        list.add(st);
        String sparqlCommand = this.createDeleteDataCommand(list, contexts);
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
        try {
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        String sparqlCommand = this.createDeleteDataCommand(statements, contexts);
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
        try {
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void removeNamespace(String prefix) throws RepositoryException {
    }

    @Override
    public void setNamespace(String prefix, String name) throws RepositoryException {
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws RepositoryException, MalformedQueryException {
        if (QueryLanguage.SPARQL.equals(ql)) {
            return new SPARQLUpdate(this.getRepository().getHTTPClient(), baseURI, update);
        }
        throw new UnsupportedQueryLanguageException("Unsupported query language " + ql);
    }

    private void setBindings(Query query, Resource subj, URI pred, Value obj, Resource ... contexts) throws RepositoryException {
        if (subj != null) {
            query.setBinding("s", subj);
        }
        if (pred != null) {
            query.setBinding("p", pred);
        }
        if (obj != null) {
            query.setBinding("o", obj);
        }
        if (contexts != null && contexts.length > 0) {
            DatasetImpl dataset = new DatasetImpl();
            for (Resource ctx : contexts) {
                if (ctx != null && !(ctx instanceof URI)) {
                    throw new RepositoryException("Contexts must be URIs");
                }
                dataset.addDefaultGraph((URI)ctx);
            }
            query.setDataset(dataset);
        }
    }

    private String createInsertDataCommand(Iterable<? extends Statement> statements, Resource ... contexts) {
        StringBuilder qb = new StringBuilder();
        qb.append("INSERT DATA \n");
        qb.append("{ \n");
        if (contexts.length > 0) {
            for (Resource context : contexts) {
                if (context != null) {
                    String namedGraph = context.stringValue();
                    if (context instanceof BNode) {
                        namedGraph = "urn:nodeid:" + context.stringValue();
                    }
                    qb.append("    GRAPH <" + namedGraph + "> { \n");
                }
                this.createDataBody(qb, statements);
                if (context == null || !(context instanceof URI)) continue;
                qb.append(" } \n");
            }
        } else {
            this.createDataBody(qb, statements);
        }
        qb.append("}");
        return qb.toString();
    }

    private String createDeleteDataCommand(Iterable<? extends Statement> statements, Resource ... contexts) {
        StringBuilder qb = new StringBuilder();
        qb.append("DELETE DATA \n");
        qb.append("{ \n");
        if (contexts.length > 0) {
            for (Resource context : contexts) {
                if (context != null) {
                    String namedGraph = context.stringValue();
                    if (context instanceof BNode) {
                        namedGraph = "urn:nodeid:" + context.stringValue();
                    }
                    qb.append("    GRAPH <" + namedGraph + "> { \n");
                }
                this.createDataBody(qb, statements);
                if (context == null || !(context instanceof URI)) continue;
                qb.append(" } \n");
            }
        } else {
            this.createDataBody(qb, statements);
        }
        qb.append("}");
        return qb.toString();
    }

    private void createDataBody(StringBuilder qb, Iterable<? extends Statement> statements) {
        for (Statement statement : statements) {
            if (statement.getSubject() instanceof BNode) {
                qb.append("_:" + statement.getSubject().stringValue() + " ");
            } else {
                qb.append("<" + statement.getSubject().stringValue() + "> ");
            }
            qb.append("<" + statement.getPredicate().stringValue() + "> ");
            if (statement.getObject() instanceof Literal) {
                Literal lit = (Literal)statement.getObject();
                qb.append("\"");
                qb.append(SPARQLUtil.encodeString(lit.getLabel()));
                qb.append("\"");
                if (lit.getLanguage() != null) {
                    qb.append("@");
                    qb.append(lit.getLanguage());
                } else if (lit.getDatatype() != null) {
                    qb.append("^^<" + lit.getDatatype().stringValue() + ">");
                }
                qb.append(" ");
            } else if (statement.getObject() instanceof BNode) {
                qb.append("_:" + statement.getObject().stringValue() + " ");
            } else {
                qb.append("<" + statement.getObject().stringValue() + "> ");
            }
            qb.append(". \n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() throws UnknownTransactionStateException, RepositoryException {
        Object object = this.transactionLock;
        synchronized (object) {
            return this.sparqlTransaction != null;
        }
    }

    @Override
    protected void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        ValueFactory f = this.getValueFactory();
        Statement st = f.createStatement(subject, predicate, object);
        ArrayList<Statement> list = new ArrayList<Statement>(1);
        list.add(st);
        String sparqlCommand = this.createInsertDataCommand(list, contexts);
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
    }

    @Override
    protected void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        String sparqlCommand = "";
        if (subject != null && predicate != null && object != null) {
            ValueFactory f = this.getValueFactory();
            Statement st = f.createStatement(subject, predicate, object);
            ArrayList<Statement> list = new ArrayList<Statement>(1);
            list.add(st);
            sparqlCommand = this.createDeleteDataCommand(list, contexts);
        } else {
            sparqlCommand = this.createDeletePatternCommand(subject, predicate, object, contexts);
        }
        this.sparqlTransaction.append(sparqlCommand);
        this.sparqlTransaction.append("; ");
    }

    private String createDeletePatternCommand(Resource subject, URI predicate, Value object, Resource[] contexts) {
        StringBuilder qb = new StringBuilder();
        qb.append("DELETE WHERE \n");
        qb.append("{ \n");
        if (contexts.length > 0) {
            for (Resource context : contexts) {
                if (context != null) {
                    String namedGraph = context.stringValue();
                    if (context instanceof BNode) {
                        namedGraph = "urn:nodeid:" + context.stringValue();
                    }
                    qb.append("    GRAPH <" + namedGraph + "> { \n");
                }
                this.createBGP(qb, subject, predicate, object);
                if (context == null || !(context instanceof URI)) continue;
                qb.append(" } \n");
            }
        } else {
            this.createBGP(qb, subject, predicate, object);
        }
        qb.append("}");
        return qb.toString();
    }

    private void createBGP(StringBuilder qb, Resource subject, URI predicate, Value object) {
        if (subject != null) {
            if (subject instanceof BNode) {
                qb.append("_:" + subject.stringValue() + " ");
            } else {
                qb.append("<" + subject.stringValue() + "> ");
            }
        } else {
            qb.append("?subj");
        }
        if (predicate != null) {
            qb.append("<" + predicate.stringValue() + "> ");
        } else {
            qb.append("?pred");
        }
        if (object != null) {
            if (object instanceof Literal) {
                Literal lit = (Literal)object;
                qb.append("\"");
                qb.append(SPARQLUtil.encodeString(lit.getLabel()));
                qb.append("\"");
                if (lit.getLanguage() != null) {
                    qb.append("@");
                    qb.append(lit.getLanguage());
                } else if (lit.getDatatype() != null) {
                    qb.append("^^<" + lit.getDatatype().stringValue() + ">");
                }
                qb.append(" ");
            } else if (object instanceof BNode) {
                qb.append("_:" + object.stringValue() + " ");
            } else {
                qb.append("<" + object.stringValue() + "> ");
            }
        } else {
            qb.append("?obj");
        }
        qb.append(". \n");
    }
}

