/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.model;

import info.aduna.iteration.LookAheadIteration;
import info.aduna.lang.ObjectUtil;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemStatementList;
import org.openrdf.sail.memory.model.MemURI;
import org.openrdf.sail.memory.model.MemValue;
import org.openrdf.sail.memory.model.ReadMode;
import org.openrdf.sail.memory.model.TxnStatus;

public class MemStatementIterator<X extends Exception>
extends LookAheadIteration<MemStatement, X> {
    private final MemStatementList statementList;
    private final MemResource subject;
    private final MemURI predicate;
    private final MemValue object;
    private final MemResource[] contexts;
    private final boolean explicitOnly;
    private final int snapshot;
    private final ReadMode readMode;
    private volatile int statementIdx;

    public MemStatementIterator(MemStatementList statementList, MemResource subject, MemURI predicate, MemValue object, boolean explicitOnly, int snapshot, ReadMode readMode, MemResource ... contexts) {
        this.statementList = statementList;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.contexts = contexts;
        this.explicitOnly = explicitOnly;
        this.snapshot = snapshot;
        this.readMode = readMode;
        this.statementIdx = -1;
    }

    @Override
    protected MemStatement getNextElement() {
        ++this.statementIdx;
        while (this.statementIdx < this.statementList.size()) {
            block6: {
                TxnStatus txnStatus;
                MemStatement st;
                block7: {
                    st = this.statementList.get(this.statementIdx);
                    if (!st.isInSnapshot(this.snapshot) || this.subject != null && this.subject != st.getSubject() || this.predicate != null && this.predicate != st.getPredicate() || this.object != null && this.object != st.getObject()) break block6;
                    if (this.contexts == null || this.contexts.length <= 0) break block7;
                    boolean matchingContext = false;
                    for (int i = 0; i < this.contexts.length && !matchingContext; ++i) {
                        matchingContext = ObjectUtil.nullEquals(st.getContext(), this.contexts[i]);
                    }
                    if (!matchingContext) break block6;
                }
                if (!(ReadMode.COMMITTED.equals((Object)this.readMode) ? st.getTxnStatus() == TxnStatus.NEW || this.explicitOnly && !st.isExplicit() : (ReadMode.TRANSACTION.equals((Object)this.readMode) ? TxnStatus.DEPRECATED.equals(txnStatus = st.getTxnStatus()) || TxnStatus.ZOMBIE.equals(txnStatus) || this.explicitOnly && (!st.isExplicit() && !TxnStatus.EXPLICIT.equals(txnStatus) || TxnStatus.INFERRED.equals(txnStatus)) : ReadMode.RAW.equals((Object)this.readMode) && this.explicitOnly && !st.isExplicit()))) {
                    return st;
                }
            }
            ++this.statementIdx;
        }
        return null;
    }
}

