/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.extraction.rvf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.traversal.classical.BFS;
import slib.graph.model.graph.G;
import slib.graph.model.graph.utils.WalkConstraint;

public class RVF {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    protected WalkConstraint wc;
    protected G g;

    public RVF(G g, WalkConstraint wc) {
        this.g = g;
        this.wc = wc;
    }

    public Set<URI> getNeighbors(URI v) {
        return this.g.getV(v, this.wc);
    }

    public Set<URI> getRV(URI v) {
        ArrayList<URI> rv = new ArrayList<URI>();
        BFS it = new BFS(this.g, v, this.wc);
        while (it.hasNext()) {
            URI next = it.next();
            rv.add(next);
        }
        rv.remove(v);
        return new HashSet<URI>(rv);
    }

    public Map<URI, Set<URI>> getRV(Set<URI> queryVertices) {
        this.logger.debug("Get All reachable vertices : start");
        HashMap<URI, Set<URI>> allVertices = new HashMap<URI, Set<URI>>();
        for (URI v : queryVertices) {
            allVertices.put(v, this.getRV(v));
        }
        this.logger.debug("Get All reachable vertices : end");
        return allVertices;
    }

    public Map<URI, Integer> getRVnb(Set<URI> queryVertices) {
        Map<URI, Set<URI>> r = this.getRV(queryVertices);
        HashMap<URI, Integer> results = new HashMap<URI, Integer>(r.size());
        for (Map.Entry<URI, Set<URI>> entry : r.entrySet()) {
            results.put(entry.getKey(), entry.getValue().size());
        }
        return results;
    }

    public WalkConstraint getWalkConstraint() {
        return this.wc;
    }

    public void setWalkConstraint(WalkConstraint nwc) {
        this.wc = nwc;
    }
}

