/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.extraction.rvf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.graph.algo.extraction.rvf.RVF;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.graph.utils.WalkConstraintUtils;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.impl.SetUtils;

public class RVF_DAG
extends RVF {
    public RVF_DAG(G g, WalkConstraint wc) {
        super(g, wc);
    }

    public Map<URI, Set<URI>> getAllRV() throws SLIB_Ex_Critic {
        this.logger.debug("Get all reachable vertices : start");
        this.logger.debug("Walk constraint\n" + this.wc);
        HashMap<URI, Set<URI>> allVertices = new HashMap<URI, Set<URI>>();
        HashMap<URI, Integer> inDegree = new HashMap<URI, Integer>();
        HashMap<URI, Integer> inDegreeDone = new HashMap<URI, Integer>();
        ArrayList<URI> queue = new ArrayList<URI>();
        WalkConstraint oppositeWC = WalkConstraintUtils.getInverse(this.wc, false);
        this.logger.debug("Opposite Walk constraint " + oppositeWC);
        for (URI v : this.g.getV()) {
            allVertices.put(v, new HashSet());
            int sizeOpposite = 0;
            for (E e : this.g.getE(v, this.wc)) {
                if (e.getSource().equals(e.getTarget())) continue;
                ++sizeOpposite;
            }
            inDegree.put(v, sizeOpposite);
            inDegreeDone.put(v, 0);
            if (sizeOpposite != 0) continue;
            queue.add(v);
        }
        if (queue.isEmpty()) {
            throw new SLIB_Ex_Critic("Walk Constraint are to restrictive to use getAllVertices Method, cannot buil initialized queue...Cannot find terminal vertices, i.e. vertices with no reachable vertices considering walkContraint: \n" + this.wc + "\nNumber of vertices tested " + allVertices.size());
        }
        this.logger.debug("Propagation started from " + queue.size() + " vertices");
        if (queue.size() <= 10) {
            this.logger.debug(((Object)queue).toString());
        }
        while (!queue.isEmpty()) {
            URI current = (URI)queue.get(0);
            queue.remove(0);
            Set<E> edges = this.g.getE(current, oppositeWC);
            for (E e : edges) {
                Direction dir = oppositeWC.getAssociatedDirection(e.getURI());
                URI dest = e.getTarget();
                if (dir == Direction.IN) {
                    dest = e.getSource();
                }
                if (dest.equals(current)) continue;
                int done = (Integer)inDegreeDone.get(dest) + 1;
                inDegreeDone.put(dest, done);
                Set union = SetUtils.union((Collection)allVertices.get(current), (Collection)allVertices.get(dest));
                union.add(current);
                allVertices.put(dest, union);
                if (done != (Integer)inDegree.get(dest)) continue;
                queue.add(dest);
            }
        }
        this.logger.debug("Checking Treatment coherency");
        long incoherencies = 0L;
        for (URI c : inDegree.keySet()) {
            if (((Integer)inDegree.get(c)).equals(inDegreeDone.get(c))) continue;
            if (incoherencies == 0L) {
                this.logger.debug("\tURI\tIndegree\tInDegreeDone");
            }
            this.logger.debug("\t" + c + "\tIndegree " + inDegree.get(c) + "\t" + inDegreeDone.get(c));
            ++incoherencies;
        }
        this.logger.debug("Incoherencies : " + incoherencies);
        if (incoherencies != 0L) {
            String incoherenceMessage = "incoherences found during a treatment, this can be due to incoherences with regard to the graph properties expected by the treatment performed. Please check the processed graph is acyclic, i.e. is a Directed Acyclic Graph.";
            throw new SLIB_Ex_Critic("ERROR " + incoherenceMessage);
        }
        this.logger.debug("Get All reachable vertices : end");
        return allVertices;
    }

    public Map<URI, Set<URI>> getAllRVInc() throws SLIB_Ex_Critic {
        Map<URI, Set<URI>> allRVEx = this.getAllRV();
        for (URI v : allRVEx.keySet()) {
            allRVEx.get(v).add(v);
        }
        return allRVEx;
    }

    public Map<URI, Set<URI>> getTerminalVertices() {
        this.logger.info("Retrieving all reachable leaves");
        HashMap<URI, Set<URI>> allReachableLeaves = new HashMap<URI, Set<URI>>();
        HashMap<URI, Integer> inDegrees = new HashMap<URI, Integer>();
        HashMap<URI, Integer> inDegreesDone = new HashMap<URI, Integer>();
        ArrayList<URI> queue = new ArrayList<URI>();
        HashSet<URI> studiedURIs = new HashSet<URI>();
        for (E e : this.g.getE(this.wc.getAcceptedPredicates())) {
            studiedURIs.add(e.getSource());
            studiedURIs.add(e.getTarget());
        }
        for (URI v : studiedURIs) {
            allReachableLeaves.put(v, new HashSet());
            int inDegree = 0;
            for (E e : this.g.getE(this.wc.getAcceptedPredicates(), v, Direction.IN)) {
                if (e.getSource().equals(v)) continue;
                ++inDegree;
            }
            inDegrees.put(v, inDegree);
            inDegreesDone.put(v, 0);
            if (inDegree != 0) continue;
            queue.add(v);
            ((Set)allReachableLeaves.get(v)).add(v);
        }
        this.logger.info("Propagation of leave counts start from " + queue.size() + " leaves on " + this.g.getV().size() + " concepts");
        this.logger.debug("Leaves: " + queue);
        while (!queue.isEmpty()) {
            URI v = (URI)queue.get(0);
            queue.remove(0);
            Set<E> edges = this.g.getE(this.wc.getAcceptedPredicates(), v, Direction.OUT);
            for (E e : edges) {
                URI target = e.getTarget();
                if (target.equals(v)) continue;
                int degreeDone = (Integer)inDegreesDone.get(target);
                allReachableLeaves.put(target, SetUtils.union((Collection)allReachableLeaves.get(target), (Collection)allReachableLeaves.get(v)));
                inDegreesDone.put(target, degreeDone + 1);
                if (!((Integer)inDegreesDone.get(target)).equals(inDegrees.get(target))) continue;
                queue.add(target);
            }
        }
        return allReachableLeaves;
    }

    public Map<URI, Integer> computeNbPathLeadingToAllVertices() throws SLIB_Ex_Critic {
        HashMap<URI, Integer> allVertices = new HashMap<URI, Integer>();
        for (URI v : this.g.getV()) {
            allVertices.put(v, 1);
        }
        return this.propagateNbOccurences(allVertices);
    }

    public Map<URI, Integer> propagateNbOccurences(Map<URI, Integer> nbOccurrence) throws SLIB_Ex_Critic {
        HashMap<URI, Set<Object>> allVertices = new HashMap<URI, Set<Object>>();
        HashMap<URI, Integer> inDegree = new HashMap<URI, Integer>();
        HashMap<URI, Integer> inDegreeDone = new HashMap<URI, Integer>();
        HashMap<URI, Integer> nbOcc_prop = new HashMap<URI, Integer>();
        for (URI uRI : nbOccurrence.keySet()) {
            nbOcc_prop.put(uRI, nbOccurrence.get(uRI));
        }
        ArrayList<URI> queue = new ArrayList<URI>();
        for (URI v : this.g.getV()) {
            allVertices.put(v, new HashSet());
            int sizeOpposite = this.g.getE(this.wc.getAcceptedPredicates(), v, Direction.OUT).size();
            inDegree.put(v, sizeOpposite);
            inDegreeDone.put(v, 0);
            if (sizeOpposite != 0) continue;
            queue.add(v);
        }
        while (!queue.isEmpty()) {
            URI uRI = (URI)queue.get(0);
            queue.remove(0);
            ((Set)allVertices.get(uRI)).add(uRI);
            Set<E> edges = this.g.getE(this.wc.getAcceptedPredicates(), uRI, Direction.IN);
            for (E e : edges) {
                URI dest = e.getTarget();
                nbOcc_prop.put(dest, (Integer)nbOcc_prop.get(dest) + (Integer)nbOcc_prop.get(uRI));
                int done = (Integer)inDegreeDone.get(dest) + 1;
                inDegreeDone.put(dest, done);
                Set union = SetUtils.union((Collection)allVertices.get(uRI), (Collection)allVertices.get(dest));
                allVertices.put(dest, union);
                if (done != (Integer)inDegree.get(dest)) continue;
                queue.add(dest);
            }
        }
        return nbOcc_prop;
    }
}

