/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader.utils.filter.graph.gaf2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import slib.graph.io.loader.utils.filter.graph.FilterGraph;
import slib.graph.io.loader.utils.filter.graph.gaf2.FilterGraph_GAF2_cst;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.i.Conf;

public class FilterGraph_GAF2
extends FilterGraph {
    HashSet<String> taxons;
    HashSet<String> excludedEC;

    public FilterGraph_GAF2(String id) {
        super(id, FilterGraph_GAF2_cst.TYPE);
    }

    public FilterGraph_GAF2(Conf conf) throws SLIB_Ex_Critic {
        super(conf);
        String taxids = (String)conf.getParam("tax_ids");
        String ecids = (String)conf.getParam("remove_ec");
        if (taxids != null) {
            this.addTaxons(Arrays.asList(taxids.split(",")));
        }
        if (ecids != null) {
            this.addECtoExclude(Arrays.asList(ecids.split(",")));
        }
    }

    public void addTaxons(String t) {
        if (this.taxons == null) {
            this.taxons = new HashSet();
        }
        this.taxons.add(t);
    }

    public void addECtoExclude(String ec) {
        if (this.excludedEC == null) {
            this.excludedEC = new HashSet();
        }
        this.excludedEC.add(ec);
    }

    public void addECtoExclude(Collection<String> t) {
        if (this.excludedEC == null) {
            this.excludedEC = new HashSet();
        }
        this.excludedEC.addAll(t);
    }

    public void addTaxons(Collection<String> t) {
        if (this.taxons == null) {
            this.taxons = new HashSet();
        }
        this.taxons.addAll(t);
    }

    public Set<String> getTaxons() {
        return this.taxons;
    }

    public Set<String> getExcludedEC() {
        return this.excludedEC;
    }

    @Override
    public String toString() {
        String out = super.toString();
        String taxonsRestrictions = "None";
        String excludedECs = "None";
        if (this.taxons != null) {
            taxonsRestrictions = this.taxons.toString();
        }
        if (this.excludedEC != null) {
            excludedECs = this.excludedEC.toString();
        }
        out = out + "\nTaxons    : " + taxonsRestrictions;
        out = out + "\nexcludeEC : " + excludedECs;
        out = out + "\n";
        return out;
    }
}

