/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.model.impl.utils;

import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.impl.graph.elements.Edge;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.graph.model.repo.URIFactory;

public class GraphUtils {
    static Logger logger = LoggerFactory.getLogger(GraphUtils.class);

    public static E buildTriplet(Object s, Object p, Object o) {
        return GraphUtils.buildTriplet((URIFactory)URIFactoryMemory.getSingleton(), s, p, o);
    }

    public static E buildTriplet(String s, String p, String o) {
        return GraphUtils.buildTriplet((URIFactory)URIFactoryMemory.getSingleton(), s, p, o);
    }

    public static E buildTriplet(URIFactory f, String s, String p, String o) {
        return new Edge(f.getURI(s), f.getURI(p), f.getURI(o));
    }

    public static E buildTriplet(URIFactory f, Object s, Object p, Object o) {
        URI sURI = s instanceof URI ? (URI)s : f.getURI(s.toString());
        URI pURI = p instanceof URI ? (URI)p : f.getURI(p.toString());
        URI oURI = o instanceof URI ? (URI)o : f.getURI(o.toString());
        return new Edge(sURI, pURI, oURI);
    }

    public static void addTriplet(G graph, Object s, Object p, Object o) {
        graph.addE(GraphUtils.buildTriplet(s, p, o));
    }

    public static void addTriplet(G graph, String s, String p, String o) {
        graph.addE(GraphUtils.buildTriplet(s, p, o));
    }

    public static void loadStatements(G g, RepositoryResult<Statement> statements) throws RepositoryException {
        int countLoaded = 0;
        int countSkipped = 0;
        while (statements.hasNext()) {
            Statement st = statements.next();
            Resource s = st.getSubject();
            Value o = st.getObject();
            if (s instanceof URI && o instanceof URI) {
                g.addE((URI)s, st.getPredicate(), (URI)o);
                ++countLoaded;
            } else {
                ++countSkipped;
            }
            if (countLoaded % 100000 != 0) continue;
            logger.info(countLoaded + " statements already loaded");
            logger.info("Number of vertices: " + g.getV().size());
            logger.info("Number of edges   : " + g.getE().size());
        }
        logger.info("Statements: " + countLoaded + " loaded, " + countSkipped + " skipped");
    }
}

