/*
 * Decompiled with CFR 0.152.
 */
package slib.indexer.obo;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import org.openrdf.model.URI;
import slib.graph.model.repo.URIFactory;
import slib.indexer.IndexHash;
import slib.indexer.URIDescriptionBasic;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class IndexerOBO {
    static URIFactory factory;
    static boolean onTermSpec;
    static String currentURI;
    static String currentName;
    static Pattern colon;
    static Pattern exclamation;
    static Pattern spaces;
    static IndexHash index;
    static String defaultNamespace;

    public static IndexHash buildIndex(URIFactory factory, String filepath, String defaultNamespace) throws SLIB_Exception {
        IndexerOBO.factory = factory;
        index = new IndexHash();
        IndexerOBO.defaultNamespace = defaultNamespace;
        try {
            String line;
            FileInputStream fstream = new FileInputStream(filepath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            boolean metadataLoaded = false;
            while ((line = br.readLine()) != null) {
                String[] data;
                String flag = null;
                String value = null;
                line = line.trim();
                if (!metadataLoaded) {
                    if (!line.equals("[Term]") && !line.equals("[Typedef]")) continue;
                    metadataLoaded = true;
                    if (!line.equals("[Term]")) continue;
                    onTermSpec = true;
                    continue;
                }
                if (!onTermSpec) continue;
                IndexerOBO.checkLine(line);
                if (!onTermSpec || (data = IndexerOBO.getData(line, ":")).length < 2) continue;
                flag = data[0];
                value = IndexerOBO.buildValue(data, 1, ":");
                value = IndexerOBO.removeComment(value);
                if (flag.equals("id")) {
                    currentURI = IndexerOBO.buildURI(value);
                    continue;
                }
                if (!flag.equals("name")) continue;
                currentName = value;
            }
            if (onTermSpec) {
                IndexerOBO.handleTerm();
            }
            in.close();
        }
        catch (IOException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        return index;
    }

    private static String[] getDataColonSplit(String line) {
        if (line.isEmpty()) {
            return null;
        }
        String[] data = colon.split(exclamation.split(line, 2)[0], 2);
        data[0] = data[0].trim();
        if (data.length > 1) {
            data[1] = data[1].trim();
        }
        return data;
    }

    private static String buildURI(String value) throws SLIB_Ex_Critic {
        String[] info = IndexerOBO.getDataColonSplit(value);
        if (info != null && info.length == 2) {
            String ns = factory.getNamespace(info[0]);
            if (ns == null) {
                throw new SLIB_Ex_Critic("No namespace associated to prefix " + info[0] + ". Cannot load " + value + ", please load required namespace prefix");
            }
            return ns + info[1];
        }
        if (defaultNamespace == null) {
            throw new SLIB_Ex_Critic("No default-namespace. Cannot load " + value + ", please load required namespace prefix");
        }
        return defaultNamespace + value;
    }

    private static String[] getData(String line, String regex) {
        String[] data_prec = line.split("!");
        String[] data = data_prec[0].split(regex);
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i].trim();
        }
        return data;
    }

    private static String removeComment(String value) {
        return value.split("!")[0].trim();
    }

    private static String buildValue(String[] data, int from, String glue) {
        String value = "";
        for (int i = from; i < data.length; ++i) {
            if (i != from) {
                value = value + glue;
            }
            value = value + data[i];
        }
        return value;
    }

    private static void checkLine(String line) throws SLIB_Ex_Critic {
        if (line.equals("[Term]")) {
            IndexerOBO.handleTerm();
            onTermSpec = true;
        }
    }

    private static void handleTerm() throws SLIB_Ex_Critic {
        if (onTermSpec) {
            URI uri = factory.getURI(currentURI);
            URIDescriptionBasic i = new URIDescriptionBasic(uri, currentName);
            index.addDescription(uri, i);
            currentURI = null;
            currentName = null;
        }
    }

    static {
        onTermSpec = false;
        currentURI = null;
        currentName = null;
        colon = Pattern.compile(":");
        exclamation = Pattern.compile("!");
        spaces = Pattern.compile("\\s+");
    }
}

