/*
 * Decompiled with CFR 0.152.
 */
package slib.indexer.wordnet;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.model.graph.G;
import slib.graph.model.repo.URIFactory;
import slib.utils.ex.SLIB_Ex_Critic;

public class IndexerWordNetBasic {
    Map<String, Set<URI>> stringToSynsetIndex = new HashMap<String, Set<URI>>();
    Logger logger = LoggerFactory.getLogger(this.getClass());
    G graph;

    public IndexerWordNetBasic() {
    }

    public IndexerWordNetBasic(URIFactory factory, G g, String file) throws SLIB_Ex_Critic {
        this.graph = g;
        this.populateIndex(factory, file);
    }

    private void populateIndex(URIFactory factory, String filepath) throws SLIB_Ex_Critic {
        this.logger.info("---------------------------------");
        this.logger.info("Populating index from " + filepath);
        boolean inHeader = true;
        try {
            String line;
            FileInputStream fstream = new FileInputStream(filepath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                if (inHeader) {
                    if (line.startsWith("  ")) continue;
                    inHeader = false;
                }
                line = line.trim();
                String[] data = line.split("\\s+");
                String valString = data[0];
                String pos = data[1];
                int synset_cnt = Integer.parseInt(data[2]);
                int p_cnt = Integer.parseInt(data[3]);
                int c = 4 + p_cnt;
                int sense_cnt = Integer.parseInt(data[c]);
                c += 2;
                HashSet<URI> synsets = new HashSet<URI>();
                for (int i = 0; i < sense_cnt; ++i) {
                    URI u = factory.getURI(this.graph.getURI().getNamespace() + "" + data[c + i]);
                    if (!this.graph.containsVertex(u)) {
                        throw new SLIB_Ex_Critic("Error cannot locate synset " + u);
                    }
                    synsets.add(u);
                }
                this.stringToSynsetIndex.put(valString, synsets);
            }
            in.close();
        }
        catch (IOException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        this.logger.info("Index build");
    }

    public Set<URI> get(String query) {
        return this.stringToSynsetIndex.get(query);
    }

    public void add(String query, URI uri) {
        if (!this.stringToSynsetIndex.containsKey(query)) {
            this.stringToSynsetIndex.put(query, new HashSet());
        }
        this.stringToSynsetIndex.get(query).add(uri);
    }

    public void add(String query, Collection<URI> uris) {
        if (!this.stringToSynsetIndex.containsKey(query)) {
            this.stringToSynsetIndex.put(query, new HashSet());
        }
        this.stringToSynsetIndex.get(query).addAll(uris);
    }

    public Map<String, Set<URI>> getIndex() {
        return this.stringToSynsetIndex;
    }
}

