/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.experimental;

import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.Sim_DAG_edge_abstract;
import slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.utils.SimDagEdgeUtils;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.SetUtils;

public class Sim_pairwise_DAG_edge_Slimani_2006
extends Sim_DAG_edge_abstract {
    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        Set<URI> ancestors_A = c.getAncestorsInc(a);
        Set<URI> ancestors_B = c.getAncestorsInc(b);
        Map<URI, Integer> maxDepths = c.getMaxDepths();
        return this.sim(a, b, ancestors_A, ancestors_B, maxDepths);
    }

    public double sim(URI cA, URI cB, Set<URI> ancestors_A, Set<URI> ancestors_B, Map<URI, Integer> maxDepths) throws SLIB_Exception {
        Set<URI> interSecAncestors;
        double sim = 0.0;
        boolean sameHierarchy = false;
        if (ancestors_A.contains(cB) || ancestors_B.contains(cA)) {
            sameHierarchy = true;
        }
        if (!(interSecAncestors = SetUtils.intersection(ancestors_A, ancestors_B)).isEmpty()) {
            URI msa = SimDagEdgeUtils.searchMSA(interSecAncestors, maxDepths);
            double d_mrca = maxDepths.get(msa).intValue();
            double d_a = maxDepths.get(cA).intValue();
            double d_b = maxDepths.get(cB).intValue();
            double pf = this.computePF(d_a, d_b, d_mrca, sameHierarchy);
            sim = 2.0 * d_mrca / (d_a + d_b + 1.0) * pf;
        }
        return sim;
    }

    private double computePF(double d_a, double d_b, double d_mrca, boolean sameHierarchy) {
        double pf = 0.0;
        double lambda = 0.0;
        if (!sameHierarchy) {
            lambda = 1.0;
        }
        double gamma = (1.0 - lambda) * (Math.min(d_a, d_b) - d_mrca + 1.0);
        double alpha = lambda * (1.0 / (Math.abs(d_a - d_b) + 1.0));
        pf = gamma + alpha;
        return pf;
    }
}

