/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.others.groupwise.direct.vector;

import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.Sim_Groupwise_Direct;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Exception;

public class VectorSpaceModel
extends Sim_Groupwise_Direct {
    @Override
    public double compare(Set<URI> setA, Set<URI> setB, SM_Engine rc, SMconf groupwiseconf) throws SLIB_Exception {
        Map<URI, Double> v1 = rc.getVector(setA, groupwiseconf);
        Map<URI, Double> v2 = rc.getVector(setB, groupwiseconf);
        double num = 0.0;
        double denum_w1 = 0.0;
        double denum_w2 = 0.0;
        for (URI v : v1.keySet()) {
            double w1 = v1.get(v);
            double w2 = v2.get(v);
            num += w1 * w2;
            denum_w1 += Math.pow(w1, 2.0);
            denum_w2 += Math.pow(w2, 2.0);
        }
        double sim = 0.0;
        if (num != 0.0) {
            sim = num / (Math.sqrt(denum_w1) * Math.sqrt(denum_w2));
        }
        sim = (double)Math.round(sim * 10000.0) / 10000.0;
        return sim;
    }
}

