/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.string;

public class LevenshteinDistance {
    double[][] mat;
    double ins = 1.0;
    double del = 1.0;
    double mismatch = 1.0;
    boolean norm = false;
    String a;
    String b;

    public LevenshteinDistance(boolean normalize) {
        this.norm = normalize;
    }

    public LevenshteinDistance(double insP, double delP, double mismatchP, boolean normalize) {
        this.ins = insP;
        this.del = delP;
        this.mismatch = mismatchP;
        this.norm = normalize;
    }

    public double distance(String a, String b) {
        this.a = a;
        this.b = b;
        double dist = a.length() == 0 ? (double)b.length() : (b.length() == 0 ? (double)a.length() : this.computeDist(a, b));
        if (this.norm) {
            dist /= (double)(b.length() > a.length() ? b.length() : a.length());
        }
        return dist;
    }

    private double computeDist(String a, String b) {
        int i;
        this.mat = new double[b.length()][a.length()];
        this.mat[0][0] = a.charAt(0) == b.charAt(0) ? 0.0 : this.mismatch;
        for (i = 1; i < a.length(); ++i) {
            this.mat[0][i] = this.mat[0][i - 1] + this.ins;
        }
        for (i = 1; i < b.length(); ++i) {
            this.mat[i][0] = this.mat[i - 1][0] + this.ins;
        }
        for (i = 1; i < a.length(); ++i) {
            for (int j = 1; j < b.length(); ++j) {
                this.mat[j][i] = this.getMin(i, j);
            }
        }
        return this.mat[b.length() - 1][a.length() - 1];
    }

    private double getMin(int i, int j) {
        double insert = this.mat[j - 1][i] + this.ins;
        double delet = this.mat[j][i - 1] + this.del;
        double mism = this.mat[j - 1][i - 1] + (this.b.charAt(j) == this.a.charAt(i) ? 0.0 : this.mismatch);
        double score = insert <= delet ? (insert < mism ? insert : mism) : (delet < mism ? delet : mism);
        return score;
    }
}

