/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.metrics.ic.topo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.metrics.ic.topo.ICtopo;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Topo;
import slib.sml.sm.core.metrics.utils.LogBasedMetric;
import slib.sml.sm.core.utils.MathSML;
import slib.utils.ex.SLIB_Ex_Critic;

public class ICi_harispe_2012
extends LogBasedMetric
implements ICtopo {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public Map<URI, Double> compute(Map<URI, Integer> allNbOfReachableLeaves, Map<URI, Integer> allNbAncestors) throws SLIB_Ex_Critic {
        HashMap<URI, Double> results = new HashMap<URI, Double>();
        double max_leaves = Collections.max(allNbOfReachableLeaves.values()).intValue();
        for (URI v : allNbAncestors.keySet()) {
            double nbAncestorsInc = allNbAncestors.get(v).doubleValue();
            double nbLeavesExclusif = allNbOfReachableLeaves.get(v).doubleValue();
            double cur_ic = this.compute(nbLeavesExclusif, nbAncestorsInc, max_leaves);
            results.put(v, cur_ic);
        }
        return results;
    }

    public double compute(double nbLeaves, double nbAncestors, double maxLeaves) {
        double x = nbLeaves / nbAncestors / maxLeaves;
        return -MathSML.log(x, this.getLogBase());
    }

    @Override
    public Map<URI, Double> compute(IC_Conf_Topo conf, SM_Engine manager) throws SLIB_Ex_Critic {
        this.setLogBase(conf);
        Map<URI, Integer> allNbAncestors = manager.getAllNbAncestorsInc();
        Map<URI, Integer> allNbReachableLeaves = manager.getAllNbReachableLeaves();
        return this.compute(allNbReachableLeaves, allNbAncestors);
    }
}

