/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.module;

import java.util.Arrays;
import slib.graph.io.loader.utils.filter.graph.Filter;
import slib.graph.io.loader.utils.filter.graph.FilterCst;
import slib.graph.io.loader.utils.filter.graph.FilterGraph;
import slib.graph.io.loader.utils.filter.graph.gaf2.FilterGraph_GAF2;
import slib.graph.io.loader.utils.filter.graph.gaf2.FilterGraph_GAF2_cst;
import slib.graph.io.loader.utils.filter.graph.metrics.FilterGraph_Metrics;
import slib.graph.io.loader.utils.filter.graph.metrics.FilterGraph_Metrics_cst;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.i.Conf;
import slib.utils.impl.Util;

public class FilterBuilderGeneric {
    public static Filter buildFilter(Conf gconf) throws SLIB_Ex_Critic {
        FilterGraph f = null;
        String id = (String)gconf.getParam("id");
        String type = (String)gconf.getParam("type");
        if (id == null) {
            Util.error("Missing id in a filter specification");
        }
        if (type == null) {
            Util.error("Missing type in a filter specification");
        }
        if (!FilterBuilderGeneric.supportType(type)) {
            Util.error("Unsupported Filter type " + type + " found in filter '" + id + "' specification");
        }
        if (type.equals(FilterGraph_GAF2_cst.TYPE)) {
            f = new FilterGraph_GAF2(gconf);
        } else if (type.equals(FilterGraph_Metrics_cst.TYPE)) {
            f = new FilterGraph_Metrics(gconf);
        } else {
            throw new UnsupportedOperationException("Sorry, filter is not taking into account, please repor the issue");
        }
        return f;
    }

    public static boolean supportType(String type) {
        return Arrays.asList(FilterCst.supportedTypes).contains(type);
    }
}

