/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.smltoolkit;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.tools.module.CmdHandler;
import slib.tools.smltoolkit.SmlModuleCLI;
import slib.tools.smltoolkit.SmlToolKitCliCst;
import slib.tools.smltoolkit.SmlToolKitCst;
import slib.tools.smltoolkit.sm.cli.core.SmCli;
import slib.utils.ex.SLIB_Exception;

public class SmlToolKitCli
extends CmdHandler {
    public String tool = null;
    static Logger logger = LoggerFactory.getLogger(SmlToolKitCli.class);
    String[] argsTool;
    String[] argsGeneral;
    CommandLine argsGeneralCMD;

    public SmlToolKitCli() throws SLIB_Exception {
        super(new SmlToolKitCst(), new SmlToolKitCliCst());
    }

    @Override
    public void processArgs(String[] args) throws SLIB_Exception {
        this.preProcessArgs(args);
        logger.info("Args " + Arrays.toString(this.argsGeneral));
        logger.info("Args Tool    " + Arrays.toString(this.argsTool));
        BasicParser parser = new BasicParser();
        try {
            this.argsGeneralCMD = parser.parse(this.options, this.argsGeneral);
            if (this.argsGeneral.length == 0 || this.argsGeneralCMD.hasOption("help")) {
                this.ending(null, true);
            } else if (this.argsGeneralCMD.hasOption("version")) {
                this.ending("version " + this.cst.version + " snapshot " + this.cst.versionSnapshot, false);
            } else if (this.argsGeneralCMD.hasOption("t")) {
                this.tool = this.argsGeneralCMD.getOptionValue("t");
            } else {
                this.ending(SmlToolKitCliCst.errorTool, true);
            }
        }
        catch (ParseException exp) {
            this.ending("Error : sml-toolkit-<version>.jar  Parsing failed.  Trace: " + exp.getMessage(), true);
        }
        this.launch();
    }

    private void launch() throws SLIB_Exception {
        SmlModuleCLI cli = null;
        if (this.tool == null) {
            this.ending("", true);
        } else if (!Arrays.asList(SmlToolKitCliCst.acceptedTools).contains(this.tool)) {
            this.ending(SmlToolKitCliCst.errorTool, true);
        } else if (this.tool.equals("sm")) {
            logger.info("Loading SM Tool");
            cli = new SmCli();
        }
        if (cli != null) {
            cli.execute(this.argsTool);
        }
    }

    private void preProcessArgs(String[] args) {
        ArrayList<String> argsModule_ = new ArrayList<String>();
        ArrayList<String> argsGeneral_ = new ArrayList<String>();
        boolean moduleArgs = false;
        boolean prefmoduleArgs = false;
        for (String arg : args) {
            if (moduleArgs) {
                argsModule_.add(arg);
                continue;
            }
            argsGeneral_.add(arg);
            if (arg.equals("-t")) {
                prefmoduleArgs = true;
                continue;
            }
            if (!prefmoduleArgs) continue;
            moduleArgs = true;
        }
        String[] strArray = new String[argsModule_.size()];
        this.argsTool = argsModule_.toArray(strArray);
        String[] strArrayb = new String[argsGeneral_.size()];
        this.argsGeneral = argsGeneral_.toArray(strArrayb);
    }

    public static void main(String[] args) {
        try {
            SmlToolKitCli c = new SmlToolKitCli();
            c.processArgs(args);
        }
        catch (SLIB_Exception e) {
            logger.error("\n\n[Error] " + e.getMessage() + "\n");
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            System.exit(-1);
        }
    }
}

