/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.smltoolkit.sm.cli.core;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.extraction.rvf.instances.InstancesAccessor;
import slib.graph.algo.extraction.rvf.instances.impl.InstanceAccessor_RDF_TYPE;
import slib.graph.algo.validator.dag.ValidatorDAG;
import slib.graph.io.loader.GraphLoaderGeneric;
import slib.graph.model.graph.G;
import slib.graph.model.impl.repo.GraphRepositoryMemory;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.graph.model.repo.URIFactory;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.metrics.ic.utils.ICconf;
import slib.sml.sm.core.utils.SMConstants;
import slib.sml.sm.core.utils.SMconf;
import slib.tools.smltoolkit.SmlModuleCLI;
import slib.tools.smltoolkit.sm.cli.conf.xml.loader.Sm_XMLConfLoader;
import slib.tools.smltoolkit.sm.cli.core.cmd.SmCmdHandler;
import slib.tools.smltoolkit.sm.cli.core.utils.ActionParamsUtils;
import slib.tools.smltoolkit.sm.cli.core.utils.ActionsParams;
import slib.tools.smltoolkit.sm.cli.core.utils.FileWriterUtil;
import slib.tools.smltoolkit.sm.cli.core.utils.QueryConceptsIterator;
import slib.tools.smltoolkit.sm.cli.core.utils.SMQueryParam;
import slib.tools.smltoolkit.sm.cli.core.utils.calc.ConceptToConcept_Thread;
import slib.tools.smltoolkit.sm.cli.core.utils.calc.EntityToEntity_Thread;
import slib.tools.smltoolkit.sm.cli.core.utils.calc.ThreadResultsQueryLoader;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.i.Conf;
import slib.utils.impl.QueryEntry;
import slib.utils.impl.QueryFileIterator;
import slib.utils.impl.QueryIterator;
import slib.utils.impl.Util;
import slib.utils.threads.PoolWorker;
import slib.utils.threads.ThreadManager;

public class SmCli
implements SmlModuleCLI {
    Logger logger = LoggerFactory.getLogger(SmCli.class);
    public Sm_XMLConfLoader conf;
    public SM_Engine simManager;
    InstancesAccessor iAccessor;
    URIFactory factory = URIFactoryMemory.getSingleton();
    G graph;
    private final ActionsParams NO_ANNOTATION_ACTION = ActionsParams.EXCLUDE;
    private final ActionsParams NOT_FOUND_ACTION = ActionsParams.STOP;
    private final double NO_ANNOTATION_SCORE = 0.0;
    private final double NOT_FOUND_SCORE = 0.0;
    public boolean QUIET = false;
    private final boolean OUTPUT_BASE_NAME = true;
    private int SIZE_BENCH = 5000;
    private boolean CACHE_PAIRWISE_RESULTS = false;

    @Override
    public void execute(String[] args) throws SLIB_Exception {
        SmCmdHandler c = new SmCmdHandler();
        c.processArgs(args);
        if (c.xmlConfFile != null) {
            this.execute(c.xmlConfFile);
        } else {
            String profileconf = System.getProperty("user.dir") + "/sml-xmlconf.xml";
            this.logger.info("Writing profile configuration to " + profileconf);
            FileWriterUtil.writeToFile(profileconf, c.xmlConfAsString);
            this.execute(profileconf);
            this.logger.info("A profile has been executed");
            this.logger.info("The XML configuration can be retrieved at " + profileconf);
        }
    }

    public void execute(String confFile) throws SLIB_Exception {
        this.logger.info("---------------------------------------------------------------");
        this.logger.info(" Processing XML configuration " + confFile);
        this.logger.info("---------------------------------------------------------------");
        this.conf = new Sm_XMLConfLoader(confFile);
        GraphLoaderGeneric.load(this.conf.generic.getGraphConfs());
        this.logger.info("Retrieving the graph " + this.conf.graphURI);
        URI graphURI = this.factory.getURI(this.conf.graphURI);
        GraphRepositoryMemory graphRepo = GraphRepositoryMemory.getSingleton();
        if (!graphRepo.isGraphRegistred(graphURI)) {
            Util.error("No graph associated to the uri " + this.conf.graphURI + " was loaded...");
        }
        this.graph = graphRepo.getGraph(graphURI);
        this.logger.info("Graph information:\n" + this.graph.toString());
        this.simManager = new SM_Engine(this.graph);
        for (ICconf icConf : this.conf.gConfICs) {
            this.simManager.computeIC(icConf);
        }
        if (this.conf.getCachePairwiseResults() == null) {
            this.simManager.setCachePairwiseResults(this.CACHE_PAIRWISE_RESULTS);
        } else {
            this.simManager.setCachePairwiseResults(this.conf.getCachePairwiseResults());
        }
        if (this.conf.getBenchSize() != null) {
            this.SIZE_BENCH = this.conf.getBenchSize();
        }
        this.QUIET = this.conf.isQuiet();
        this.logger.info("---------------------------------------------------------------");
        this.logger.info(" Global parameters");
        this.logger.info("---------------------------------------------------------------");
        this.logger.info("quiet      : " + this.QUIET);
        this.logger.info("Bench size : " + this.SIZE_BENCH);
        this.logger.info("Number of threads allowed: " + ThreadManager.getSingleton().getCapacity());
        this.logger.info("---------------------------------------------------------------");
        if (this.requireDAG()) {
            this.logger.info("checking DAG property");
            ValidatorDAG dagVal = new ValidatorDAG();
            boolean rootedGraph = dagVal.containsTaxonomicDagWithUniqueRoot(this.graph);
            if (!rootedGraph) {
                this.logger.error("Multiple root detected please specify a root or use root=\"FICTIVE\"");
            }
        }
        this.iAccessor = new InstanceAccessor_RDF_TYPE(this.graph);
        this.computeQueries();
        this.logger.info("process done");
        this.logger.info("---------------------------------------------------------------");
    }

    private void computeQueries() throws SLIB_Exception {
        this.logger.info("---------------------------------------------------------------");
        this.logger.info("Start computation of " + this.conf.gConfQueries.size() + " queries");
        try {
            for (Conf gconf : this.conf.gConfQueries) {
                QueryIterator qloader;
                String id = (String)gconf.getParam("id");
                String type = (String)gconf.getParam("type");
                String infile = (String)gconf.getParam("file");
                String output = (String)gconf.getParam("output");
                String uri_prefix = (String)gconf.getParam("uri_prefix");
                String use_uri_prefix = (String)gconf.getParam("use_uri_prefix");
                String use_uri_prefix_output = (String)gconf.getParam("use_uri_prefix_output");
                String noAnnotsConf_s = (String)gconf.getParam("noAnnots");
                String notFound_s = (String)gconf.getParam("notFound");
                String outputBaseName_s = (String)gconf.getParam("output_basename");
                boolean outputBasedName = true;
                ActionsParams noAnnotAction = this.NO_ANNOTATION_ACTION;
                ActionsParams noFoundAction = this.NOT_FOUND_ACTION;
                double noAnnotationScore = 0.0;
                double noFoundScore = 0.0;
                boolean useLoadedURIprefixes = Util.stringToBoolean(use_uri_prefix);
                boolean useLoadedURIprefixesOutput = Util.stringToBoolean(use_uri_prefix_output);
                if (outputBaseName_s != null) {
                    outputBasedName = Util.stringToBoolean(outputBaseName_s);
                }
                if (notFound_s != null && (noFoundAction = ActionParamsUtils.getAction(notFound_s)) == ActionsParams.SET) {
                    noFoundScore = ActionParamsUtils.getSetValue(notFound_s);
                }
                if (noAnnotsConf_s != null && (noAnnotAction = ActionParamsUtils.getAction(noAnnotsConf_s)) == ActionsParams.SET) {
                    noAnnotationScore = ActionParamsUtils.getSetValue(noAnnotsConf_s);
                }
                if (uri_prefix == null) {
                    uri_prefix = "";
                } else if (useLoadedURIprefixes) {
                    throw new SLIB_Ex_Critic("Error loading query " + id + ", parameters " + "uri_prefix" + " and " + "use_uri_prefix" + " cannot be used togethers. Consult documentation");
                }
                SMQueryParam queryParam = new SMQueryParam(id);
                queryParam.setNoAnnotAction(noAnnotAction).setNoAnnotationScore(noAnnotationScore).setNoFoundAction(noFoundAction).setNoFoundScore(noFoundScore).setOutputBaseName(outputBasedName).setInfile(infile).setOutfile(output).setType(type).setUseLoadedURIprefixes(useLoadedURIprefixes).setUseLoadedURIprefixesOutput(useLoadedURIprefixesOutput);
                this.logger.info("---------------------------------------------------------------");
                this.logger.info("Query :" + queryParam.getId());
                this.logger.info("---------------------------------------------------------------");
                this.logger.info(queryParam.toString());
                if (type.equals("cTOc") || type.equals("oTOo")) {
                    qloader = new QueryFileIterator(infile, uri_prefix);
                    if (type.equals("cTOc")) {
                        this.perform_cTOc(qloader, queryParam);
                        continue;
                    }
                    if (!type.equals("oTOo")) continue;
                    this.perform_oTOo(qloader, queryParam);
                    continue;
                }
                if (type.equals("cTOc_full")) {
                    qloader = new QueryConceptsIterator(this.simManager.getClasses());
                    this.perform_cTOc(qloader, queryParam);
                    continue;
                }
                throw new UnsupportedOperationException(type + " is not a supported " + "type" + " of queries");
            }
        }
        catch (IOException e) {
            throw new SLIB_Exception(e);
        }
        catch (SLIB_Exception e) {
            throw new SLIB_Exception(e);
        }
        catch (UnsupportedOperationException e) {
            throw new SLIB_Exception(e);
        }
    }

    private void perform_oTOo(QueryIterator qloader, SMQueryParam queryParam) throws SLIB_Exception {
        this.logger.info("Starting computing query oTOo");
        ThreadManager threadManager = ThreadManager.getSingleton();
        PoolWorker poolWorker = null;
        try {
            long queryNumber = qloader.getNumberQueries();
            this.logger.info("Number of query ~" + queryNumber);
            long queryNumberLogStep = queryNumber / 10L;
            int nbLogStep = 0;
            FileWriter fstream = new FileWriter(queryParam.getOutfile());
            BufferedWriter file = new BufferedWriter(fstream);
            String header = "e1\te2";
            int nbMeasures = this.conf.gConfGroupwise.size();
            for (SMconf m : this.conf.gConfGroupwise) {
                header = header + "\t" + m.getLabel();
            }
            file.write(header + "\n");
            int skipped = 0;
            int setValue = 0;
            poolWorker = threadManager.getMaxLoadPoolWorker();
            long count = 0L;
            ArrayList<Future<ThreadResultsQueryLoader>> results = new ArrayList<Future<ThreadResultsQueryLoader>>();
            this.logger.info("processing queries...");
            while (qloader.hasNext()) {
                poolWorker.awaitFreeResource();
                List<QueryEntry> queriesBench = qloader.nextValids(this.SIZE_BENCH);
                EntityToEntity_Thread callable = new EntityToEntity_Thread(poolWorker, queriesBench, this, nbMeasures, queryParam);
                poolWorker.addTask();
                Future<ThreadResultsQueryLoader> future = poolWorker.getPool().submit(callable);
                results.add(future);
                Iterator it = results.iterator();
                while (it.hasNext()) {
                    Future r = (Future)it.next();
                    if (!r.isDone()) continue;
                    ThreadResultsQueryLoader rez = (ThreadResultsQueryLoader)r.get();
                    file.write(rez.buffer.toString());
                    skipped += rez.getSkipped();
                    setValue += rez.getSetValue();
                    if (!this.QUIET && (count += (long)rez.getJobSize()) > (long)nbLogStep * queryNumberLogStep) {
                        this.logger.info("- " + count + " / ~" + queryNumber + "\tskipped " + skipped + "\tsetted results " + setValue);
                        ++nbLogStep;
                    }
                    it.remove();
                }
            }
            qloader.close();
            poolWorker.shutdown();
            Iterator it = results.iterator();
            while (it.hasNext()) {
                Future r = (Future)it.next();
                if (!r.isDone()) continue;
                ThreadResultsQueryLoader rez = (ThreadResultsQueryLoader)r.get();
                file.write(rez.buffer.toString());
                skipped += rez.getSkipped();
                setValue += rez.getSetValue();
                count += (long)rez.getJobSize();
                if (!this.QUIET) {
                    this.logger.info("- " + count + " / ~" + queryNumber + "\tskipped " + skipped + "\tsetted results " + setValue);
                }
                it.remove();
            }
            file.close();
            this.logger.info(count + " queries considered");
            if (count == 0L) {
                this.logger.info("Nothing to do... Please check your query file if any.");
            } else {
                this.logger.info("skipped:" + skipped + "/" + count + "(" + (long)(skipped * 100) / count + "%)");
                this.logger.info("setted :" + setValue + "/" + count + "(" + (long)(setValue * 100) / count + "%)");
                this.logger.info("consult:" + queryParam.getOutfile());
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SLIB_Exception(e);
        }
        finally {
            if (poolWorker != null) {
                poolWorker.forceShutdown();
            }
        }
    }

    private void perform_cTOc(QueryIterator qloader, SMQueryParam queryParam) throws SLIB_Exception {
        this.logger.info("Starting computing query cTOc");
        ThreadManager threadManager = ThreadManager.getSingleton();
        PoolWorker poolWorker = null;
        try {
            long queryNumber = qloader.getNumberQueries();
            this.logger.info("Number of query ~" + queryNumber);
            long queryNumberLogStep = queryNumber / 10L;
            int nbLogStep = 0;
            FileWriter fstream = new FileWriter(queryParam.getOutfile());
            BufferedWriter file = new BufferedWriter(fstream);
            String header = "c1\tc2";
            for (SMconf m : this.conf.gConfPairwise) {
                header = header + "\t" + m.getLabel();
            }
            file.write(header + "\n");
            int skipped = 0;
            int setValue = 0;
            poolWorker = threadManager.getMaxLoadPoolWorker();
            long count = 0L;
            ArrayList<Future<ThreadResultsQueryLoader>> results = new ArrayList<Future<ThreadResultsQueryLoader>>();
            this.logger.info("processing queries...");
            while (qloader.hasNext()) {
                poolWorker.awaitFreeResource();
                List<QueryEntry> queriesBench = qloader.nextValids(this.SIZE_BENCH);
                ConceptToConcept_Thread callable = new ConceptToConcept_Thread(poolWorker, queriesBench, this, queryParam);
                poolWorker.addTask();
                Future<ThreadResultsQueryLoader> future = poolWorker.getPool().submit(callable);
                results.add(future);
                Iterator it = results.iterator();
                while (it.hasNext()) {
                    Future r = (Future)it.next();
                    if (!r.isDone()) continue;
                    ThreadResultsQueryLoader rez = (ThreadResultsQueryLoader)r.get();
                    file.write(rez.buffer.toString());
                    skipped += rez.getSkipped();
                    setValue += rez.getSetValue();
                    if (!this.QUIET && (count += (long)rez.getJobSize()) > (long)nbLogStep * queryNumberLogStep) {
                        this.logger.info("- " + count + " / ~" + queryNumber + "\tskipped " + skipped + "\tsetted results " + setValue);
                        ++nbLogStep;
                    }
                    it.remove();
                }
            }
            qloader.close();
            poolWorker.shutdown();
            Iterator it = results.iterator();
            while (it.hasNext()) {
                Future r = (Future)it.next();
                if (!r.isDone()) continue;
                ThreadResultsQueryLoader rez = (ThreadResultsQueryLoader)r.get();
                file.write(rez.buffer.toString());
                skipped += rez.getSkipped();
                setValue += rez.getSetValue();
                count += (long)rez.getJobSize();
                if (!this.QUIET) {
                    this.logger.info("- " + count + " / ~" + queryNumber + "\tskipped " + skipped + "\tsetted results " + setValue);
                }
                it.remove();
            }
            file.close();
            this.logger.info(count + " queries considered");
            if (count == 0L) {
                this.logger.info("Nothing to do... Please check your query file if any.");
            } else {
                this.logger.info("skipped:" + skipped + "/" + count + " (" + (long)(skipped * 100) / count + "%)");
                this.logger.info("setted :" + setValue + "/" + count + " (" + (long)(setValue * 100) / count + "%)");
                this.logger.info("consult:" + queryParam.getOutfile());
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SLIB_Exception(e);
        }
        finally {
            if (poolWorker != null) {
                poolWorker.forceShutdown();
            }
        }
    }

    public ICconf getICconf(String icID) {
        for (ICconf g : this.conf.gConfICs) {
            if (!g.getId().equals(icID)) continue;
            return g;
        }
        return null;
    }

    private boolean requireDAG() {
        for (SMconf c : this.conf.gConfPairwise) {
            int mApproach = SMConstants.getPairwiseApproach(c.getFlag());
            if (!SMConstants.requireDAG(mApproach)) continue;
            return true;
        }
        return false;
    }

    public G getGraph() {
        return this.graph;
    }

    public InstancesAccessor getiAccessor() {
        return this.iAccessor;
    }
}

