/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.smltoolkit.sm.cli.core.cmd;

import java.util.Arrays;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.tools.module.CmdHandler;
import slib.tools.smltoolkit.sm.cli.core.cmd.SmCmdHandlerCst;
import slib.tools.smltoolkit.sm.cli.core.utils.SmToolkitCst;
import slib.tools.smltoolkit.sm.cli.profile.go.SmProfile_GO;
import slib.tools.smltoolkit.sm.cli.profile.mesh.SmProfile_MeSH;
import slib.utils.ex.SLIB_Exception;

public class SmCmdHandler
extends CmdHandler {
    public String xmlConfFile;
    public String xmlConfAsString;
    public String profile;
    static Logger logger = LoggerFactory.getLogger(SmCmdHandler.class);

    public SmCmdHandler() throws SLIB_Exception {
        super(new SmToolkitCst(), new SmCmdHandlerCst());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processArgs(String[] args) throws SLIB_Exception {
        BasicParser parser = new BasicParser();
        Object[] argSMProfile = null;
        Object[] argSMmodule = args.length < 2 ? args : new String[]{args[0], args[1]};
        if (args.length - 2 > 0) {
            argSMProfile = new String[args.length - 2];
            for (int i = 2; i < args.length; ++i) {
                argSMProfile[i - 2] = args[i];
            }
        }
        logger.debug("Global args  " + Arrays.toString(args));
        logger.debug("Module SM    " + Arrays.toString(argSMmodule));
        logger.debug("Profile args " + Arrays.toString(argSMProfile));
        try {
            CommandLine line = parser.parse(this.options, (String[])argSMmodule);
            if (argSMmodule.length == 0 || line.hasOption("help")) {
                this.ending(null, true);
                return;
            } else if (line.hasOption("xmlconf")) {
                this.xmlConfFile = line.getOptionValue("xmlconf");
                return;
            } else if (line.hasOption("profile")) {
                this.profile = line.getOptionValue("profile");
                logger.info("Process profile: " + this.profile);
                if (this.profile.toUpperCase().equals("GO")) {
                    SmProfile_GO goprofile = new SmProfile_GO();
                    goprofile.execute((String[])argSMProfile);
                    this.xmlConfAsString = goprofile.xmlconf;
                    return;
                } else {
                    if (!this.profile.toUpperCase().equals("MESH")) throw new SLIB_Exception("Unsupported profile, admitted " + Arrays.toString(SmCmdHandlerCst.admittedProfiles));
                    logger.info("Loading MeSH config loader");
                    SmProfile_MeSH meshProfile = new SmProfile_MeSH();
                    meshProfile.execute((String[])argSMProfile);
                    this.xmlConfAsString = meshProfile.xmlconf;
                }
                return;
            } else {
                this.ending("[ERROR] Please specify a profile or an Xml configuration file", true);
            }
            return;
        }
        catch (ParseException exp) {
            this.ending(this.cst.appName + " Parsing failed.  Reason: " + exp.getMessage(), true);
        }
    }
}

