/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.smltoolkit.sm.cli.core.utils.calc;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.extraction.rvf.instances.InstancesAccessor;
import slib.graph.model.graph.G;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.sml.sm.core.utils.SMConstants;
import slib.sml.sm.core.utils.SMconf;
import slib.tools.smltoolkit.sm.cli.core.SmCli;
import slib.tools.smltoolkit.sm.cli.core.utils.ActionsParams;
import slib.tools.smltoolkit.sm.cli.core.utils.SMQueryParam;
import slib.tools.smltoolkit.sm.cli.core.utils.SMutils;
import slib.tools.smltoolkit.sm.cli.core.utils.calc.ThreadResultsQueryLoader;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.impl.QueryEntry;
import slib.utils.threads.PoolWorker;

public class EntityToEntity_Thread
implements Callable<ThreadResultsQueryLoader> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    PoolWorker poolWorker;
    int skipped = 0;
    int setValue = 0;
    Collection<QueryEntry> queriesBench;
    InstancesAccessor iAccessor;
    SMQueryParam queryParam;
    SmCli sspM;
    G g;
    private int nbMeasures;

    public EntityToEntity_Thread(PoolWorker poolWorker, Collection<QueryEntry> queriesBench, SmCli sspM, int nbMeasures, SMQueryParam queryParam) {
        this.poolWorker = poolWorker;
        this.queriesBench = queriesBench;
        this.sspM = sspM;
        this.nbMeasures = nbMeasures;
        this.g = sspM.getGraph();
        this.iAccessor = sspM.getiAccessor();
        this.queryParam = queryParam;
    }

    @Override
    public ThreadResultsQueryLoader call() throws Exception {
        ThreadResultsQueryLoader results = null;
        try {
            results = new ThreadResultsQueryLoader(this.queriesBench.size());
            URIFactoryMemory factory = URIFactoryMemory.getSingleton();
            StringBuilder tmp_buffer = new StringBuilder();
            boolean printBaseName = this.queryParam.isOutputBaseName();
            boolean useLoadedPrefixes = this.queryParam.isUseLoadedURIprefixes();
            boolean useLoadedPrefixesOutput = this.queryParam.isUseLoadedURIprefixesOutput();
            for (QueryEntry q : this.queriesBench) {
                URI e2;
                URI e1;
                results.buffer.append((CharSequence)tmp_buffer);
                tmp_buffer.delete(0, tmp_buffer.length());
                String uriE1s = q.getKey();
                String uriE2s = q.getValue();
                try {
                    e1 = factory.getURI(uriE1s, useLoadedPrefixes);
                    e2 = factory.getURI(uriE2s, useLoadedPrefixes);
                }
                catch (IllegalArgumentException e) {
                    throw new SLIB_Ex_Critic("Query file contains an invalid URI: " + e.getMessage());
                }
                String ids_pairs = printBaseName ? (useLoadedPrefixesOutput ? factory.shortURIasString(e1) + "\t" + factory.shortURIasString(e2) : uriE1s + "\t" + uriE2s) : e1.getLocalName() + "\t" + e2.getLocalName();
                if (!this.g.containsVertex(e1) || !this.g.containsVertex(e2)) {
                    if (this.queryParam.getNoFoundAction() == ActionsParams.SET) {
                        ++this.setValue;
                        tmp_buffer.append(ids_pairs);
                        for (int i = 0; i < this.nbMeasures; ++i) {
                            tmp_buffer.append("\t").append(this.queryParam.getNoFoundScore());
                        }
                        tmp_buffer.append("\n");
                    } else if (this.queryParam.getNoFoundAction() == ActionsParams.EXCLUDE) {
                        ++this.skipped;
                    } else if (this.queryParam.getNoFoundAction() == ActionsParams.STOP) {
                        if (!this.g.containsVertex(e1)) {
                            throw new SLIB_Ex_Critic("Cannot locate " + e1 + " in " + this.g.getURI());
                        }
                        if (!this.g.containsVertex(e2)) {
                            throw new SLIB_Ex_Critic("Cannot locate " + e2 + " in " + this.g.getURI());
                        }
                    }
                    if (this.sspM.QUIET) continue;
                    this.logger.info((Object)((Object)this.queryParam.getNoFoundAction()) + " " + e1 + " (FOUND = " + this.g.containsVertex(e1) + ") / " + e2 + " (FOUND = " + this.g.containsVertex(e2) + ")");
                    continue;
                }
                Set<URI> setE1 = this.iAccessor.getDirectClass(e1);
                Set<URI> setE2 = this.iAccessor.getDirectClass(e2);
                if (setE1.isEmpty() || setE2.isEmpty()) {
                    if (this.queryParam.getNoAnnotAction() == ActionsParams.SET) {
                        ++this.setValue;
                        tmp_buffer.append(ids_pairs);
                        for (int i = 0; i < this.nbMeasures; ++i) {
                            tmp_buffer.append("\t").append(this.queryParam.getNoAnnotationScore());
                        }
                        tmp_buffer.append("\n");
                        results.buffer.append((CharSequence)tmp_buffer);
                    } else if (this.queryParam.getNoAnnotAction() == ActionsParams.EXCLUDE) {
                        ++this.skipped;
                    } else if (this.queryParam.getNoAnnotAction() == ActionsParams.STOP) {
                        throw new SLIB_Ex_Critic("Stop the execution because an entry contains an element without annotations " + e1 + " (annot size = " + setE1.size() + ") / " + e2 + " (annot size = " + setE2.size() + "). You can exclude those entries or set a value, please consult the documentation");
                    }
                    if (this.sspM.QUIET) continue;
                    this.logger.info((Object)((Object)this.queryParam.getNoAnnotAction()) + " " + e1 + " (annot size = " + setE1.size() + ") / " + e2 + " (annot size = " + setE2.size() + ")");
                    continue;
                }
                tmp_buffer.append(ids_pairs);
                for (SMconf m : this.sspM.conf.gConfGroupwise) {
                    double sim;
                    if (SMConstants.SIM_GROUPWISE_ADD_ON.containsKey(m.getFlag())) {
                        String pm_id = m.getParamAsString("pairwise_measure");
                        SMconf pm_conf = null;
                        for (SMconf p : this.sspM.conf.gConfPairwise) {
                            if (!pm_id.equals(p.getId())) continue;
                            pm_conf = p;
                            break;
                        }
                        if (pm_conf == null) {
                            throw new SLIB_Ex_Critic("Cannot locate configuration associated to pairwise measure " + pm_id);
                        }
                        sim = this.sspM.simManager.compare(m, pm_conf, setE1, setE2);
                        tmp_buffer.append("\t").append(sim);
                        if (!Double.isNaN(sim) && !Double.isInfinite(sim)) continue;
                        SMutils.throwArithmeticCriticalException(m, pm_conf, e1, e2, sim);
                        continue;
                    }
                    sim = this.sspM.simManager.compare(m, setE1, setE2);
                    if (Double.isNaN(sim) || Double.isInfinite(sim)) {
                        SMutils.throwArithmeticCriticalException(m, e1, e2, sim);
                    }
                    tmp_buffer.append("\t");
                    tmp_buffer.append(sim);
                }
                tmp_buffer.append("\n");
            }
            results.buffer.append((CharSequence)tmp_buffer);
            results.setSetValue(this.setValue);
            results.setSkipped(this.skipped);
        }
        catch (SLIB_Ex_Critic e) {
            if (this.logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new Exception(e);
        }
        finally {
            this.poolWorker.taskComplete();
        }
        return results;
    }
}

