/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.smltoolkit.sm.cli.profile.mesh;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import slib.tools.module.ToolCmdHandlerCst;

public class SmProfileMeSHCst
extends ToolCmdHandlerCst {
    private static final String _moduleName = "sm";
    private static final String _appCmdName = "sml-toolkit-<version>.jar  -t sm -profile MESH";
    private static final boolean _debugMode = false;
    static String ANNOTSFORMAT_DEFAULT = "TSV";
    static String MTYPE_PAIRWISE = "p";
    static String MTYPE_GROUPWISE = "g";
    static String MTYPE_DEFAULT = "p";
    static String NOTFOUND_DEFAULT = "exclude";
    static String NOANNOTS_DEFAULT = "set=-1";
    static String THREADS_DEFAULT = "1";
    private static final Option _mesh;
    private static final Option _annots;
    private static final Option _queries;
    private static final Option _output;
    private static final Option _mtype;
    private static final Option _notfound;
    private static final Option _pm;
    private static final Option _gm;
    private static final Option _ic;
    private static final Option _quiet;
    private static final Option _notr;
    private static final Option _notrannots;
    private static final Option _threads;
    private static final Map<Option, Integer> _optionsOrder;

    public SmProfileMeSHCst() {
        super(_appCmdName, false, _optionsOrder);
    }

    static {
        OptionBuilder.withArgName("file path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nThe path to the MeSH XML format - from version 2014, e.g. desc2014.xml. This file is required. The DTD, e.g. desc2014.dtd, must also be located in the same directory\n");
        _mesh = OptionBuilder.create("mesh");
        OptionBuilder.withArgName("file path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nThe path to the annotation file. This file defines a set of entities characterised by a set of MeSH descriptors (DescriptorUIs), e.g., documents annotated by MesH descriptors. The file must contains an entity description per line. The entry must be of the form entity id[tabulation]list of mesh descriptors (DescriptorUIs) separated by ';'. This file is required for groupwise measures (-mtype g see above) or any measure relying on a extrinsic metric (e.g. Resnik's Information Content)");
        _annots = OptionBuilder.create("annots");
        OptionBuilder.withArgName("file path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nThe path to the file which contains the queries (one per line), i.e. the pairs of MeSH descriptors or the pairs of entity ids. In all cases, the entity or MeSH descriptor ids must be separated by a tabulation, i.e. each line must be of the form id_1[tabulation]id_2. This file is always required. An example is provided above.");
        _queries = OptionBuilder.create("queries");
        OptionBuilder.withArgName("file path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nOutput file to store the results (required)");
        _output = OptionBuilder.create("output");
        OptionBuilder.withArgName("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nThe type of semantic measures you want to use:\n- 'p' (pairwise) to compute semantic measures between MeSH descriptors.\n- 'g' (groupwise) to compute semantic measures between sets of MeSH descriptors.\naccepted values [p,g], default p\nexample -mtype p");
        _mtype = OptionBuilder.create("mtype");
        OptionBuilder.withArgName("flag");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nDefine the behavior if an entry element of the query file cannot be found: (i) in pairwise measures: one of the two MeSH descriptors cannot be found, (ii) in groupwise measures: one of the two gene products cannot be found. Accepted values [exclude, stop, set=<value>]:\n- 'exclude' the entry will not be processed (a message will be logged if -quiet is not used)\n- 'stop'    the program will stop\n- 'set=<value>' the entry will not be processed (a message will be logged if -quiet is not used).\ndefault value = 'exclude'");
        _notfound = OptionBuilder.create("notfound");
        OptionBuilder.withArgName("flag");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nPairwise measure [ 'resnik', 'lin', 'schlicker', 'jc' ] (required for pairwise measures or indirect groupwise measures). See the complete list on the website.");
        _pm = OptionBuilder.create("pm");
        OptionBuilder.withArgName("flag");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nDirect groupwise measure [ 'to', 'nto', 'gic', 'ui', ... ] or aggregation method (mixing strategy) [ 'min', 'max', 'bma', 'bmm', ... ] if an indirect groupwise measure is be used (require a pairwise measure to be set). See the complete list on the website.");
        _gm = OptionBuilder.create("gm");
        OptionBuilder.withArgName("flag");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nInformation content method. Extrinsic (require annotation file): [ 'resnik' ], Intrinsic : [ 'sanchez', 'zhou', 'seco' ]. See the complete list on the website.");
        _ic = OptionBuilder.create("ic");
        OptionBuilder.withArgName("quiet");
        OptionBuilder.withDescription("\nDo not show warning messages");
        _quiet = OptionBuilder.create("quiet");
        OptionBuilder.withArgName("notr");
        OptionBuilder.withDescription("\nDo not perform a transitive reduction of the MeSH");
        _notr = OptionBuilder.create("notrmesh");
        OptionBuilder.withArgName("notrannots");
        OptionBuilder.withDescription("\nDo not remove annotation redundancy, i.e. if an entity is annoted by two MeSH descriptors {X,Y} and X is subsumed by Y in the MeSH, the MeSH descriptor Y will be removed from the annotations.");
        _notrannots = OptionBuilder.create("notrannots");
        OptionBuilder.withArgName("nb");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("\nInteger definying the number of threads to use, i.e. processes allocates to the execution, default 1.\n Setting more threads reduce execution time, suited configuration depends on tour computer, use with care if you don't get the implications in term of computational resources which will be used.");
        _threads = OptionBuilder.create("threads");
        _optionsOrder = new LinkedHashMap<Option, Integer>();
        _optionsOrder.put(_mesh, _optionsOrder.size());
        _optionsOrder.put(_annots, _optionsOrder.size());
        _optionsOrder.put(_queries, _optionsOrder.size());
        _optionsOrder.put(_output, _optionsOrder.size());
        _optionsOrder.put(_mtype, _optionsOrder.size());
        _optionsOrder.put(_notfound, _optionsOrder.size());
        _optionsOrder.put(_pm, _optionsOrder.size());
        _optionsOrder.put(_gm, _optionsOrder.size());
        _optionsOrder.put(_ic, _optionsOrder.size());
        _optionsOrder.put(_quiet, _optionsOrder.size());
        _optionsOrder.put(_notr, _optionsOrder.size());
        _optionsOrder.put(_notrannots, _optionsOrder.size());
        _optionsOrder.put(_threads, _optionsOrder.size());
    }
}

