/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.smltoolkit.sm.cli.profile.mesh;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.tools.module.CmdHandler;
import slib.tools.smltoolkit.sm.cli.core.utils.SML_SM_module_XML_block_conf;
import slib.tools.smltoolkit.sm.cli.profile.go.SmProfileGOHandler;
import slib.tools.smltoolkit.sm.cli.profile.mesh.SmProfileMeSHCst;
import slib.tools.smltoolkit.sm.cli.profile.mesh.SmToolkitMeSHCst;
import slib.utils.ex.SLIB_Exception;

public class SmProfileMeSHHandler
extends CmdHandler {
    SML_SM_module_XML_block_conf smconf;
    static Logger logger = LoggerFactory.getLogger(SmProfileGOHandler.class);

    public SmProfileMeSHHandler(String[] args) throws SLIB_Exception {
        super(new SmToolkitMeSHCst(), new SmProfileMeSHCst());
    }

    @Override
    public void processArgs(String[] args) {
        this.smconf = new SML_SM_module_XML_block_conf();
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(this.options, args);
            if (args == null || args.length == 0 || line.hasOption("help")) {
                String mess = null;
                if (args == null || args.length == 0) {
                    mess = "No arguments...";
                }
                this.ending(mess, true, false, true);
            } else {
                if (line.hasOption("mesh")) {
                    this.smconf.setOntologyPath(line.getOptionValue("mesh"));
                }
                if (line.hasOption("annots")) {
                    this.smconf.setAnnotsPath(line.getOptionValue("annots"));
                }
                this.smconf.setAnnotsFormat(SmProfileMeSHCst.ANNOTSFORMAT_DEFAULT);
                if (line.hasOption("queries")) {
                    this.smconf.setQueries(line.getOptionValue("queries"));
                }
                if (line.hasOption("output")) {
                    this.smconf.setOutput(line.getOptionValue("output"));
                }
                if (line.hasOption("mtype")) {
                    this.smconf.setMtype(line.getOptionValue("mtype"));
                } else {
                    this.smconf.setMtype(SmProfileMeSHCst.MTYPE_DEFAULT);
                }
                if (line.hasOption("notfound")) {
                    this.smconf.setNotFound(line.getOptionValue("notfound"));
                } else {
                    this.smconf.setNotFound(SmProfileMeSHCst.NOTFOUND_DEFAULT);
                }
                if (line.hasOption("noannots")) {
                    this.smconf.setNoAnnots(line.getOptionValue("noannots"));
                } else {
                    this.smconf.setNoAnnots(SmProfileMeSHCst.NOANNOTS_DEFAULT);
                }
                if (line.hasOption("pm")) {
                    this.smconf.setPmShortFlag(line.getOptionValue("pm"));
                }
                if (line.hasOption("gm")) {
                    this.smconf.setGmShortFlag(line.getOptionValue("gm"));
                }
                if (line.hasOption("ic")) {
                    this.smconf.setIcShortFlag(line.getOptionValue("ic"));
                }
                if (line.hasOption("threads")) {
                    this.smconf.setThreads(line.getOptionValue("threads"));
                } else {
                    this.smconf.setThreads(SmProfileMeSHCst.THREADS_DEFAULT);
                }
                if (line.hasOption("notrmesh")) {
                    this.smconf.setNoTR_KR("true");
                }
                if (line.hasOption("notrannots")) {
                    this.smconf.setNoTR_Annots("true");
                }
                if (line.hasOption("quiet")) {
                    this.smconf.setQuiet("true");
                }
            }
        }
        catch (ParseException exp) {
            this.ending(this.cst.appName + " Parsing failed.  Reason: " + exp.getMessage(), true);
        }
    }

    public SML_SM_module_XML_block_conf getSmconf() {
        return this.smconf;
    }
}

